/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.FadvisedFileRegion;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFadvisedFileRegion {
    private final int FILE_SIZE = 0x1000000;
    private static final Log LOG = LogFactory.getLog(TestFadvisedFileRegion.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=100000L)
    public void testCustomShuffleTransfer() throws IOException {
        FileChannel target;
        RandomAccessFile targetFile;
        RandomAccessFile inputFile;
        int count;
        int position;
        byte[] initBuff;
        File outFile;
        File inFile;
        File testDir;
        File absLogDir;
        block9: {
            absLogDir = new File("target", TestFadvisedFileRegion.class.getSimpleName() + "LocDir").getAbsoluteFile();
            String testDirPath = StringUtils.join((CharSequence)"/", (String[])new String[]{absLogDir.getAbsolutePath(), "testCustomShuffleTransfer"});
            testDir = new File(testDirPath);
            testDir.mkdirs();
            System.out.println(testDir.getAbsolutePath());
            inFile = new File(testDir, "fileIn.out");
            outFile = new File(testDir, "fileOut.out");
            initBuff = new byte[0x1000000];
            Random rand = new Random();
            rand.nextBytes(initBuff);
            FileOutputStream out = new FileOutputStream(inFile);
            try {
                out.write(initBuff);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            position = 0x200000;
            count = 0x3FFFFF;
            inputFile = null;
            targetFile = null;
            target = null;
            FadvisedFileRegion fileRegion = null;
            try {}
            catch (Throwable throwable) {
                if (fileRegion != null) {
                    fileRegion.releaseExternalResources();
                }
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{target});
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{targetFile});
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{inputFile});
                throw throwable;
            }
            {
                long size;
                inputFile = new RandomAccessFile(inFile.getAbsolutePath(), "r");
                targetFile = new RandomAccessFile(outFile.getAbsolutePath(), "rw");
                target = targetFile.getChannel();
                Assert.assertEquals((long)0x1000000L, (long)inputFile.length());
                fileRegion = new FadvisedFileRegion(inputFile, (long)position, (long)count, false, 0, null, null, 1024, false);
                TestFadvisedFileRegion.customShuffleTransferCornerCases((FadvisedFileRegion)fileRegion, (WritableByteChannel)target, (int)count);
                long pos = 0L;
                while ((size = fileRegion.customShuffleTransfer((WritableByteChannel)target, pos)) > 0L) {
                    pos += size;
                }
                Assert.assertEquals((long)count, (long)((int)pos));
                Assert.assertEquals((long)count, (long)targetFile.length());
                if (fileRegion == null) break block9;
            }
            fileRegion.releaseExternalResources();
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{target});
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{targetFile});
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{inputFile});
        byte[] buff = new byte[0x1000000];
        FileInputStream in = new FileInputStream(outFile);
        try {}
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        {
            int total = in.read(buff, 0, count);
            Assert.assertEquals((long)count, (long)total);
            for (int i = 0; i < count; ++i) {
                Assert.assertEquals((long)initBuff[position + i], (long)buff[i]);
            }
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        inFile.delete();
        outFile.delete();
        testDir.delete();
        absLogDir.delete();
    }

    private static void customShuffleTransferCornerCases(FadvisedFileRegion fileRegion, WritableByteChannel target, int count) {
        try {
            fileRegion.customShuffleTransfer(target, -1L);
            Assert.fail((String)"Expected a IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            LOG.info((Object)"Expected - illegal argument is passed.");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a IllegalArgumentException");
        }
        try {
            fileRegion.customShuffleTransfer(target, (long)(count + 1));
            Assert.fail((String)"Expected a IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            LOG.info((Object)"Expected - illegal argument is passed.");
        }
        catch (Exception e) {
            Assert.fail((String)"Expected a IllegalArgumentException");
        }
    }
}

