/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.WordMedian;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WordMedian
extends Configured
implements Tool {
    private double median = 0.0;
    private static final IntWritable ONE = new IntWritable(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readAndFindMedian(String path, int medianIndex1, int medianIndex2, Configuration conf) throws IOException {
        Path file;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(file = new Path(path, "part-r-00000"))) {
            throw new IOException("Output not found!");
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(file)));
            int num = 0;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String currLen = st.nextToken();
                String lengthFreq = st.nextToken();
                int prevNum = num;
                if (medianIndex2 >= prevNum && medianIndex1 <= (num += Integer.parseInt(lengthFreq))) {
                    System.out.println("The median is: " + currLen);
                    br.close();
                    double d = Double.parseDouble(currLen);
                    return d;
                }
                if (medianIndex2 < prevNum || medianIndex1 >= num) continue;
                String nextCurrLen = st.nextToken();
                double theMedian = (double)(Integer.parseInt(currLen) + Integer.parseInt(nextCurrLen)) / 2.0;
                System.out.println("The median is: " + theMedian);
                br.close();
                double d = theMedian;
                return d;
            }
        }
        finally {
            br.close();
        }
        return -1.0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new WordMedian(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: wordmedian <in> <out>");
            return 0;
        }
        this.setConf(new Configuration());
        Configuration conf = this.getConf();
        Job job = new Job(conf, "word median");
        job.setJarByClass(WordMedian.class);
        job.setMapperClass(WordMedianMapper.class);
        job.setCombinerClass(WordMedianReducer.class);
        job.setReducerClass(WordMedianReducer.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        boolean result = job.waitForCompletion(true);
        long totalWords = ((CounterGroup)job.getCounters().getGroup(TaskCounter.class.getCanonicalName())).findCounter("MAP_OUTPUT_RECORDS", "Map output records").getValue();
        int medianIndex1 = (int)Math.ceil((double)totalWords / 2.0);
        int medianIndex2 = (int)Math.floor((double)totalWords / 2.0);
        this.median = this.readAndFindMedian(args[1], medianIndex1, medianIndex2, conf);
        return result ? 0 : 1;
    }

    public double getMedian() {
        return this.median;
    }

    static /* synthetic */ IntWritable access$000() {
        return ONE;
    }
}

