/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.dancing;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.dancing.DistributedPentomino;
import org.apache.hadoop.examples.dancing.OneSidedPentomino;
import org.apache.hadoop.examples.dancing.Pentomino;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistributedPentomino
extends Configured
implements Tool {
    private static final int PENT_DEPTH = 5;
    private static final int PENT_WIDTH = 9;
    private static final int PENT_HEIGHT = 10;
    private static final int DEFAULT_MAPS = 2000;

    private static long createInputDirectory(FileSystem fs, Path dir, Pentomino pent, int depth) throws IOException {
        fs.mkdirs(dir);
        List splits = pent.getSplits(depth);
        Path input = new Path(dir, "part1");
        PrintStream file = new PrintStream(new BufferedOutputStream((OutputStream)fs.create(input), 65536));
        for (int[] prefix : splits) {
            for (int i = 0; i < prefix.length; ++i) {
                if (i != 0) {
                    file.print(',');
                }
                file.print(prefix[i]);
            }
            file.print('\n');
        }
        file.close();
        return fs.getFileStatus(input).getLen();
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new DistributedPentomino(), (String[])args);
        System.exit(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("pentomino <output>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return 2;
        }
        Configuration conf = this.getConf();
        int width = conf.getInt("mapreduce.pentomino.width", 9);
        int height = conf.getInt("mapreduce.pentomino.height", 10);
        int depth = conf.getInt("mapreduce.pentomino.depth", 5);
        Class pentClass = conf.getClass("mapreduce.pentomino.class", OneSidedPentomino.class, Pentomino.class);
        int numMaps = conf.getInt("mapreduce.job.maps", 2000);
        Path output = new Path(args[0]);
        Path input = new Path(output + "_input");
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        try {
            Job job = new Job(conf);
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
            FileOutputFormat.setOutputPath((Job)job, (Path)output);
            job.setJarByClass(PentMap.class);
            job.setJobName("dancingElephant");
            Pentomino pent = (Pentomino)ReflectionUtils.newInstance((Class)pentClass, (Configuration)conf);
            pent.initialize(width, height);
            long inputSize = DistributedPentomino.createInputDirectory((FileSystem)fileSys, (Path)input, (Pentomino)pent, (int)depth);
            FileInputFormat.setMaxInputSplitSize((Job)job, (long)(inputSize / (long)numMaps));
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Text.class);
            job.setMapperClass(PentMap.class);
            job.setReducerClass(Reducer.class);
            job.setNumReduceTasks(1);
            int n = job.waitForCompletion(true) ? 0 : 1;
            return n;
        }
        finally {
            fileSys.delete(input, true);
        }
    }
}

