/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.ArithmeticProgression;
import org.apache.hadoop.examples.pi.math.Summation;
import org.apache.hadoop.examples.pi.math.TestSummation;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestSummation
extends TestCase {
    static final Random RANDOM = new Random();
    static final BigInteger TWO = BigInteger.valueOf(2L);

    private static Summation2 newSummation(long base, long range, long delta) {
        ArithmeticProgression N = new ArithmeticProgression('n', base + 3L, delta, base + 3L + range);
        ArithmeticProgression E = new ArithmeticProgression('e', base + range, -delta, base);
        return new Summation2(N, E);
    }

    private static void runTestSubtract(Summation sigma, List<Summation> diff) {
        ArrayList<Summation> tmp = new ArrayList<Summation>(diff.size());
        for (Summation s : diff) {
            tmp.add(s);
        }
        List a = sigma.remainingTerms(tmp);
        a.addAll(diff);
        for (Summation s : a) {
            s.compute();
        }
        List combined = Util.combine((Collection)a);
        TestSummation.assertEquals((int)1, (int)combined.size());
        TestSummation.assertEquals((Object)sigma, combined.get(0));
    }

    public void testSubtract() {
        Summation2 sigma = TestSummation.newSummation((long)3L, (long)10000L, (long)20L);
        int size = 10;
        List<Summation> parts = Arrays.asList(sigma.partition(10));
        Collections.sort(parts);
        TestSummation.runTestSubtract((Summation)sigma, new ArrayList());
        TestSummation.runTestSubtract((Summation)sigma, parts);
        for (int n = 1; n < 10; ++n) {
            for (int j = 0; j < 10; ++j) {
                ArrayList<Summation> diff = new ArrayList<Summation>(parts);
                for (int i = 0; i < n; ++i) {
                    diff.remove(RANDOM.nextInt(diff.size()));
                }
                TestSummation.runTestSubtract((Summation)sigma, diff);
            }
        }
    }

    private static void computeBenchmarks(Summation2 sigma) {
        Util.Timer t = new Util.Timer(false);
        t.tick("sigma=" + sigma);
        double value = sigma.compute();
        t.tick("compute=" + value);
        TestSummation.assertEquals((Object)value, (Object)sigma.compute_modular());
        t.tick("compute_modular");
        TestSummation.assertEquals((Object)value, (Object)sigma.compute_montgomery());
        t.tick("compute_montgomery");
        TestSummation.assertEquals((Object)value, (Object)sigma.compute_montgomery2());
        t.tick("compute_montgomery2");
        TestSummation.assertEquals((Object)value, (Object)sigma.compute_modBigInteger());
        t.tick("compute_modBigInteger");
        TestSummation.assertEquals((Object)value, (Object)sigma.compute_modPow());
        t.tick("compute_modPow");
    }

    public static void main(String[] args) {
        long delta = 16L;
        long range = 0x100000L;
        for (int i = 20; i < 40; i += 2) {
            TestSummation.computeBenchmarks((Summation2)TestSummation.newSummation((long)(1L << i), (long)0x100000L, (long)16L));
        }
    }
}

