/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.pi.DistSum;
import org.apache.hadoop.examples.pi.Parser;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Bellard;
import org.apache.hadoop.examples.pi.math.Summation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class DistBbp
extends Configured
implements Tool {
    public static final String DESCRIPTION = "A map/reduce program that uses a BBP-type formula to compute exact bits of Pi.";
    private final Util.Timer timer = new Util.Timer(true);

    public int run(String[] args) throws Exception {
        if (args.length != 7) {
            return Util.printUsage((String[])args, (String)(this.getClass().getName() + " <b> " + "<nThreads> <nJobs> <type> <nPart> <remoteDir> <localDir>" + "\n  <b> The number of bits to skip, i.e. compute the (b+1)th position." + "\n  <nThreads> The number of working threads.\n  <nJobs> The number of jobs per sum.\n  <type> 'm' for map side job, 'r' for reduce side job, 'x' for mix type.\n  <nPart> The number of parts per job.\n  <remoteDir> Remote directory for submitting jobs.\n  <localDir> Local directory for storing output files."));
        }
        int i = 0;
        long b = Util.string2long((String)args[i++]);
        DistSum.Parameters parameters = DistSum.Parameters.parse((String[])args, (int)i);
        if (b < 0L) {
            throw new IllegalArgumentException("b = " + b + " < 0");
        }
        Util.printBitSkipped((long)b);
        Util.out.println(parameters);
        Util.out.println();
        DistSum distsum = new DistSum();
        distsum.setConf(this.getConf());
        distsum.setParameters(parameters);
        boolean isVerbose = this.getConf().getBoolean("pi.parser.verbose", false);
        Map existings = new Parser(isVerbose).parse(parameters.localDir.getPath(), null);
        Parser.combine((Map)existings);
        for (List tr : existings.values()) {
            Collections.sort(tr);
        }
        Util.out.println();
        Map sums = Bellard.getSums((long)b, (int)parameters.nJobs, (Map)existings);
        Util.out.println();
        this.execute(distsum, sums);
        double pi = Bellard.computePi((long)b, (Map)sums);
        Util.printBitSkipped((long)b);
        Util.out.println(Util.pi2string((double)pi, (long)Bellard.bit2terms((long)b)));
        return 0;
    }

    private void execute(DistSum distsum, Map<Bellard.Parameter, Bellard.Sum> sums) throws Exception {
        ArrayList<DistSum.Computation> computations = new ArrayList<DistSum.Computation>();
        int i = 0;
        for (Bellard.Parameter p : Bellard.Parameter.values()) {
            for (Summation s : sums.get(p)) {
                if (s.getValue() != null) continue;
                DistSum distSum = distsum;
                distSum.getClass();
                computations.add(new DistSum.Computation(distSum, i++, p.toString(), s));
            }
        }
        if (computations.isEmpty()) {
            Util.out.println("No computation");
        } else {
            this.timer.tick("execute " + computations.size() + " computation(s)");
            Util.execute((int)distsum.getParameters().nThreads, computations);
            this.timer.tick("done");
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run(null, (Tool)new DistBbp(), (String[])args));
    }
}

