/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.examples.pi.Combinable;
import org.apache.hadoop.examples.pi.DistSum;
import org.apache.hadoop.examples.pi.TaskResult;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Bellard;

public final class Parser {
    static final String VERBOSE_PROPERTY = "pi.parser.verbose";
    final boolean isVerbose;

    public Parser(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    private void println(String s) {
        if (this.isVerbose) {
            Util.out.println(s);
        }
    }

    private static void parseLine(String line, Map<Bellard.Parameter, List<TaskResult>> m) {
        Map.Entry<String, TaskResult> e = DistSum.string2TaskResult(line);
        if (e != null) {
            List<TaskResult> sums = m.get((Object)Bellard.Parameter.get(e.getKey()));
            if (sums == null) {
                throw new IllegalArgumentException("sums == null, line=" + line + ", e=" + e);
            }
            sums.add(e.getValue());
        }
    }

    /*
     * Exception decompiling
     */
    private void parse(File f, Map<Bellard.Parameter, List<TaskResult>> sums) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Bellard.Parameter, List<TaskResult>> parse(String f) throws IOException {
        TreeMap<Bellard.Parameter, List<TaskResult>> m = new TreeMap<Bellard.Parameter, List<TaskResult>>();
        for (Bellard.Parameter p : Bellard.Parameter.values()) {
            m.put(p, new ArrayList());
        }
        this.parse(new File(f), m);
        for (Bellard.Parameter p : Bellard.Parameter.values()) {
            m.put(p, (List<TaskResult>)m.get((Object)p));
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Bellard.Parameter, List<TaskResult>> parse(String inputpath, String outputdir) throws IOException {
        Util.out.print("\nParsing " + inputpath + " ... ");
        Util.out.flush();
        Map<Bellard.Parameter, List<TaskResult>> parsed = this.parse(inputpath);
        Util.out.println("DONE");
        if (outputdir != null) {
            Util.out.print("\nWriting to " + outputdir + " ...");
            Util.out.flush();
            for (Bellard.Parameter p : Bellard.Parameter.values()) {
                List<TaskResult> results = parsed.get((Object)p);
                Collections.sort(results);
                try (PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputdir, (Object)((Object)p) + ".txt")), Charsets.UTF_8), true);){
                    for (int i = 0; i < results.size(); ++i) {
                        out.println(DistSum.taskResult2string((Object)((Object)p) + "." + i, results.get(i)));
                    }
                }
            }
            Util.out.println("DONE");
        }
        return parsed;
    }

    static <T extends Combinable<T>> Map<Bellard.Parameter, T> combine(Map<Bellard.Parameter, List<T>> m) {
        TreeMap<Bellard.Parameter, Combinable> combined = new TreeMap<Bellard.Parameter, Combinable>();
        for (Bellard.Parameter p : Bellard.Parameter.values()) {
            List results = Util.combine((Collection)m.get((Object)p));
            Util.out.format("%-6s => ", new Object[]{p});
            if (results.size() != 1) {
                Util.out.println(results.toString().replace(", ", ",\n           "));
                continue;
            }
            Combinable r = (Combinable)results.get(0);
            combined.put(p, r);
            Util.out.println(r);
        }
        return combined;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args.length > 3) {
            Util.printUsage(args, Parser.class.getName() + " <b> <inputpath> [<outputdir>]");
        }
        int i = 0;
        long b = Util.string2long(args[i++]);
        String inputpath = args[i++];
        String outputdir = args.length >= 3 ? args[i++] : null;
        Map parsed = new Parser(true).parse(inputpath, outputdir);
        Map combined = Parser.combine(parsed);
        long duration = 0L;
        for (TaskResult r : combined.values()) {
            duration += r.getDuration();
        }
        double pi = Bellard.computePi(b, combined);
        Util.printBitSkipped(b);
        Util.out.println(Util.pi2string(pi, Bellard.bit2terms(b)));
        Util.out.println("cpu time = " + Util.millis2String(duration));
    }
}

