/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import com.google.common.annotations.VisibleForTesting;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReverseZoneUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReverseZoneUtils.class);
    private static final long POW3 = (long)Math.pow(256.0, 3.0);
    private static final long POW2 = (long)Math.pow(256.0, 2.0);
    private static final long POW1 = (long)Math.pow(256.0, 1.0);

    private ReverseZoneUtils() {
    }

    protected static String getReverseZoneNetworkAddress(String baseIp, int range, int index) throws UnknownHostException {
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Invalid index provided, must be positive: %d", index));
        }
        if (range < 0) {
            throw new IllegalArgumentException(String.format("Invalid range provided, cannot be negative: %d", range));
        }
        return ReverseZoneUtils.calculateIp(baseIp, range, index);
    }

    protected static long getSubnetCountForReverseZones(Configuration conf) {
        long ipCount;
        int parsedRange;
        String subnet = conf.get("hadoop.registry.dns.zone-subnet");
        String mask = conf.get("hadoop.registry.dns.zone-mask");
        String range = conf.get("hadoop.registry.dns.split-reverse-zone-range");
        try {
            parsedRange = Integer.parseInt(range);
        }
        catch (NumberFormatException e) {
            LOG.error("The supplied range is not a valid integer: Supplied range: ", (Object)range);
            throw e;
        }
        if (parsedRange < 0) {
            String msg = String.format("Range cannot be negative: Supplied range: %d", parsedRange);
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            SubnetUtils subnetUtils = new SubnetUtils(subnet, mask);
            subnetUtils.setInclusiveHostCount(true);
            ipCount = subnetUtils.getInfo().getAddressCountLong();
        }
        catch (IllegalArgumentException e) {
            LOG.error("The subnet or mask is invalid: Subnet: {} Mask: {}", (Object)subnet, (Object)mask);
            throw e;
        }
        if (parsedRange == 0) {
            return ipCount;
        }
        return ipCount / (long)parsedRange;
    }

    private static String calculateIp(String baseIp, int range, int index) throws UnknownHostException {
        long[] ipParts = ReverseZoneUtils.splitIp(baseIp);
        long ipNum1 = POW3 * ipParts[0];
        long ipNum2 = POW2 * ipParts[1];
        long ipNum3 = POW1 * ipParts[2];
        long ipNum4 = ipParts[3];
        long ipNum = ipNum1 + ipNum2 + ipNum3 + ipNum4;
        ArrayList<Long> ipPartsOut = new ArrayList<Long>();
        long temp = ipNum + (long)range * (long)index;
        ipPartsOut.add(0, temp / POW3);
        ipPartsOut.add(1, (temp -= (Long)ipPartsOut.get(0) * POW3) / POW2);
        ipPartsOut.add(2, (temp -= (Long)ipPartsOut.get(1) * POW2) / POW1);
        ipPartsOut.add(3, temp -= (Long)ipPartsOut.get(2) * POW1);
        return StringUtils.join(ipPartsOut, (char)'.');
    }

    @VisibleForTesting
    protected static long[] splitIp(String baseIp) throws UnknownHostException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(baseIp);
        }
        catch (UnknownHostException e) {
            LOG.error("Base IP address is invalid");
            throw e;
        }
        if (inetAddress instanceof Inet6Address) {
            throw new IllegalArgumentException("IPv6 is not yet supported for reverse zones");
        }
        byte[] octets = inetAddress.getAddress();
        if (octets.length != 4) {
            throw new IllegalArgumentException("Base IP address is invalid");
        }
        long[] results = new long[4];
        for (int i = 0; i < octets.length; ++i) {
            results[i] = octets[i] & 0xFF;
        }
        return results;
    }
}

