/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ResourceRequest
implements Comparable<ResourceRequest> {
    public static final String ANY = "*";

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers) {
        return ResourceRequest.newInstance(priority, hostName, capability, numContainers, true);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, boolean relaxLocality) {
        return ResourceRequest.newInstance(priority, hostName, capability, numContainers, relaxLocality, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, String label) {
        return ResourceRequest.newInstance(priority, hostName, capability, numContainers, true, label);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ResourceRequest newInstance(Priority priority, String hostName, Resource capability, int numContainers, boolean relaxLocality, String label) {
        ResourceRequest request = Records.newRecord(ResourceRequest.class);
        request.setPriority(priority);
        request.setResourceName(hostName);
        request.setCapability(capability);
        request.setNumContainers(numContainers);
        request.setRelaxLocality(relaxLocality);
        request.setLabel(label);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static boolean isAnyLocation(String hostName) {
        return ANY.equals(hostName);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getResourceName();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResourceName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumContainers();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setNumContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getRelaxLocality();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setRelaxLocality(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getLabel();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setLabel(String var1);

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        Resource capability = this.getCapability();
        String hostName = this.getResourceName();
        Priority priority = this.getPriority();
        String label = this.getLabel();
        result = 2153 * result + (capability == null ? 0 : capability.hashCode());
        result = 2153 * result + (hostName == null ? 0 : hostName.hashCode());
        result = 2153 * result + this.getNumContainers();
        result = 2153 * result + (priority == null ? 0 : priority.hashCode());
        result = 2153 * result + (label == null ? 0 : label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRequest other = (ResourceRequest)obj;
        Resource capability = this.getCapability();
        if (capability == null ? other.getCapability() != null : !capability.equals(other.getCapability())) {
            return false;
        }
        String hostName = this.getResourceName();
        if (hostName == null ? other.getResourceName() != null : !hostName.equals(other.getResourceName())) {
            return false;
        }
        if (this.getNumContainers() != other.getNumContainers()) {
            return false;
        }
        Priority priority = this.getPriority();
        if (priority == null ? other.getPriority() != null : !priority.equals(other.getPriority())) {
            return false;
        }
        String label = this.getLabel();
        return !(label == null ? other.getLabel() != null : !label.equals(other.getLabel()));
    }

    @Override
    public int compareTo(ResourceRequest other) {
        int priorityComparison = this.getPriority().compareTo(other.getPriority());
        if (priorityComparison == 0) {
            int hostNameComparison = this.getResourceName().compareTo(other.getResourceName());
            if (hostNameComparison == 0) {
                int capabilityComparison = this.getCapability().compareTo(other.getCapability());
                if (capabilityComparison == 0) {
                    return this.getNumContainers() - other.getNumContainers();
                }
                return capabilityComparison;
            }
            return hostNameComparison;
        }
        return priorityComparison;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static class ResourceRequestComparator
    implements Comparator<ResourceRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(ResourceRequest r1, ResourceRequest r2) {
            int ret = r1.getPriority().compareTo(r2.getPriority());
            if (ret == 0) {
                String h1 = r1.getResourceName();
                String h2 = r2.getResourceName();
                ret = h1.compareTo(h2);
            }
            if (ret == 0) {
                ret = r1.getCapability().compareTo(r2.getCapability());
            }
            return ret;
        }
    }
}

