/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import com.google.common.base.Joiner;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class WebAppUtils {
    private static final Joiner JOINER = Joiner.on((String)"");

    public static void setRMWebAppPort(Configuration conf, int port) {
        String hostname = WebAppUtils.getRMWebAppURLWithoutScheme(conf);
        hostname = hostname.contains(":") ? hostname.substring(0, hostname.indexOf(":")) : hostname;
        WebAppUtils.setRMWebAppHostnameAndPort(conf, hostname, port);
    }

    public static void setRMWebAppHostnameAndPort(Configuration conf, String hostname, int port) {
        String resolvedAddress = hostname + ":" + port;
        if (HttpConfig.isSecure()) {
            conf.set("yarn.resourcemanager.webapp.https.address", resolvedAddress);
        } else {
            conf.set("yarn.resourcemanager.webapp.address", resolvedAddress);
        }
    }

    public static void setNMWebAppHostNameAndPort(Configuration conf, String hostName, int port) {
        if (HttpConfig.isSecure()) {
            conf.set("yarn.nodemanager.webapp.https.address", hostName + ":" + port);
        } else {
            conf.set("yarn.nodemanager.webapp.address", hostName + ":" + port);
        }
    }

    public static String getRMWebAppURLWithScheme(Configuration conf) {
        return JOINER.join((Object)HttpConfig.getSchemePrefix(), (Object)(HttpConfig.isSecure() ? conf.get("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090") : conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088")), new Object[0]);
    }

    public static String getRMWebAppURLWithoutScheme(Configuration conf) {
        if (HttpConfig.isSecure()) {
            return conf.get("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090");
        }
        return conf.get("yarn.resourcemanager.webapp.address", "0.0.0.0:8088");
    }

    public static String getProxyHostAndPort(Configuration conf) {
        String addr = conf.get("yarn.web-proxy.address");
        if (addr == null || addr.isEmpty()) {
            addr = WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
        }
        return addr;
    }

    public static String getResolvedRMWebAppURLWithScheme(Configuration conf) {
        return HttpConfig.getSchemePrefix() + WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf) {
        return WebAppUtils.getResolvedRMWebAppURLWithoutScheme(conf, HttpConfig.isSecure() ? HttpConfig.Policy.HTTPS_ONLY : HttpConfig.Policy.HTTP_ONLY);
    }

    public static String getResolvedRMWebAppURLWithoutScheme(Configuration conf, HttpConfig.Policy httpPolicy) {
        InetSocketAddress address = null;
        address = httpPolicy == HttpConfig.Policy.HTTPS_ONLY ? conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8090) : conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8088);
        address = NetUtils.getConnectAddress((InetSocketAddress)address);
        StringBuffer sb = new StringBuffer();
        InetAddress resolved = address.getAddress();
        if (resolved == null || resolved.isAnyLocalAddress() || resolved.isLoopbackAddress()) {
            String lh = address.getHostName();
            try {
                lh = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sb.append(lh);
        } else {
            sb.append(address.getHostName());
        }
        sb.append(":").append(address.getPort());
        return sb.toString();
    }

    public static String getNMWebAppURLWithoutScheme(Configuration conf) {
        if (HttpConfig.isSecure()) {
            return conf.get("yarn.nodemanager.webapp.https.address", "0.0.0.0:8044");
        }
        return conf.get("yarn.nodemanager.webapp.address", "0.0.0.0:8042");
    }
}

