/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskBasedResourceCalculator
extends DefaultResourceCalculator {
    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DiskBasedResourceCalculator.divideAndCeil(numerator.getMemory(), denominator), numerator.getVirtualCores(), numerator.getDisks());
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        int normalizedMemory = Math.min(DiskBasedResourceCalculator.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), stepFactor.getMemory()), maximumResource.getMemory());
        return Resources.createResource(normalizedMemory, r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DiskBasedResourceCalculator.roundUp(r.getMemory(), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DiskBasedResourceCalculator.roundDown(r.getMemory(), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DiskBasedResourceCalculator.roundUp((int)((double)r.getMemory() * by + 0.5), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DiskBasedResourceCalculator.roundDown((int)((double)r.getMemory() * by), stepFactor.getMemory()), r.getVirtualCores(), r.getDisks());
    }

    @Override
    public int computeAvailableContainers(Resource available, Resource required) {
        double availableContainersDisk;
        int availableContainersCpu;
        int availableContainers = 0;
        if (required.getMemory() > 0) {
            availableContainers = available.getMemory() / required.getMemory();
        }
        if (required.getVirtualCores() > 0 && (availableContainersCpu = available.getVirtualCores() / required.getVirtualCores()) < availableContainers) {
            availableContainers = availableContainersCpu;
        }
        if (required.getDisks() > 0.0 && (availableContainersDisk = Math.floor(available.getDisks() / required.getDisks())) < (double)availableContainers) {
            availableContainers = (int)availableContainersDisk;
        }
        return availableContainers;
    }
}

