/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;

public class AddToClusterNodeLabelsRequestPBImpl
extends AddToClusterNodeLabelsRequest {
    YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto proto = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.Builder builder = null;
    private List<NodeLabel> updatedNodeLabels;
    boolean viaProto = false;

    public AddToClusterNodeLabelsRequestPBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.newBuilder();
    }

    public AddToClusterNodeLabelsRequestPBImpl(YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.updatedNodeLabels != null) {
            this.addNodeLabelsToProto();
        }
    }

    private void addNodeLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.builder.clearDeprecatedNodeLabels();
        ArrayList<YarnProtos.NodeLabelProto> protoList = new ArrayList<YarnProtos.NodeLabelProto>();
        ArrayList<String> protoListString = new ArrayList<String>();
        for (NodeLabel r : this.updatedNodeLabels) {
            protoList.add(this.convertToProtoFormat(r));
            protoListString.add(r.getName());
        }
        this.builder.addAllNodeLabels(protoList);
        this.builder.addAllDeprecatedNodeLabels(protoListString);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((AddToClusterNodeLabelsRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto.newBuilder((YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void initLocalNodeLabels() {
        YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto p = this.viaProto ? this.proto : this.builder;
        List attributesProtoList = p.getNodeLabelsList();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        for (YarnProtos.NodeLabelProto r : attributesProtoList) {
            this.updatedNodeLabels.add(this.convertFromProtoFormat(r));
        }
    }

    private NodeLabel convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    public String toString() {
        return this.getProto().toString();
    }

    public void setNodeLabels(List<NodeLabel> nodeLabels) {
        this.maybeInitBuilder();
        this.updatedNodeLabels = new ArrayList<NodeLabel>();
        if (nodeLabels == null) {
            this.builder.clearNodeLabels();
            return;
        }
        this.updatedNodeLabels.addAll(nodeLabels);
    }

    public List<NodeLabel> getNodeLabels() {
        if (this.updatedNodeLabels != null) {
            return this.updatedNodeLabels;
        }
        this.initLocalNodeLabels();
        return this.updatedNodeLabels;
    }
}

