/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationAttemptId {
    @Test
    public void testApplicationAttemptId() {
        ApplicationAttemptId a1 = this.createAppAttemptId(10L, 1, 1);
        ApplicationAttemptId a2 = this.createAppAttemptId(10L, 1, 2);
        ApplicationAttemptId a3 = this.createAppAttemptId(10L, 2, 1);
        ApplicationAttemptId a4 = this.createAppAttemptId(8L, 1, 4);
        ApplicationAttemptId a5 = this.createAppAttemptId(10L, 1, 1);
        Assert.assertTrue((boolean)a1.equals((Object)a5));
        Assert.assertFalse((boolean)a1.equals((Object)a2));
        Assert.assertFalse((boolean)a1.equals((Object)a3));
        Assert.assertFalse((boolean)a1.equals((Object)a4));
        Assert.assertTrue((a1.compareTo(a5) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((a1.compareTo(a2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a1.compareTo(a3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a1.compareTo(a4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((a1.hashCode() == a5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((a1.hashCode() == a2.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((a1.hashCode() == a3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((a1.hashCode() == a4.hashCode() ? 1 : 0) != 0);
        long ts = System.currentTimeMillis();
        ApplicationAttemptId a6 = this.createAppAttemptId(ts, 543627, 33492611);
        Assert.assertEquals((Object)"appattempt_10_0001_000001", (Object)a1.toString());
        Assert.assertEquals((Object)("appattempt_" + ts + "_543627_33492611"), (Object)a6.toString());
    }

    private ApplicationAttemptId createAppAttemptId(long clusterTimeStamp, int id, int attemptId) {
        ApplicationId appId = ApplicationId.newInstance((long)clusterTimeStamp, (int)id);
        return ApplicationAttemptId.newInstance((ApplicationId)appId, (int)attemptId);
    }

    public static void main(String[] args) throws Exception {
        TestApplicationAttemptId t = new TestApplicationAttemptId();
        t.testApplicationAttemptId();
    }
}

