/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.FileNotFoundException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestLogAggregationFileController {
    @Test
    public void testRemoteDirCreationDefault() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)"yarn_group"));
    }

    @Test
    public void testRemoteDirCreationWithCustomGroup() throws Exception {
        String testGroupName = "testGroup";
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        conf.set("yarn.nodemanager.remote-app-log-dir.groupname", testGroupName);
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)testGroupName));
    }
}

