/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class CustomResourceTypesConfigurationProvider
extends LocalConfigurationProvider {
    private static final String CUSTOM_RESOURCE_PREFIX = "custom-resource-";
    private static final String UNIT_KILO = "k";
    private static CustomResourceTypes customResourceTypes = CustomResourceTypesConfigurationProvider.createCustomResourceTypes(2, "k");

    public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws YarnException, IOException {
        if ("resource-types.xml".equals(name)) {
            return new ByteArrayInputStream(customResourceTypes.getXml().getBytes());
        }
        return super.getConfigurationInputStream(bootstrapConf, name);
    }

    public static void initResourceTypes(Map<String, String> resourcesWithUnits) {
        CustomResourceTypesConfigurationProvider.setResourceTypes(resourcesWithUnits);
        CustomResourceTypesConfigurationProvider.initResourceTypesInternal();
    }

    public static void initResourceTypes(int count, String units) {
        CustomResourceTypesConfigurationProvider.setResourceTypes(count, units);
        CustomResourceTypesConfigurationProvider.initResourceTypesInternal();
    }

    public static void initResourceTypes(String ... resourceTypes) {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        riMap.put("memory-mb", ResourceInformation.MEMORY_MB);
        riMap.put("vcores", ResourceInformation.VCORES);
        for (String newResource : resourceTypes) {
            riMap.put(newResource, ResourceInformation.newInstance((String)newResource, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
        }
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
    }

    private static void initResourceTypesInternal() {
        Configuration configuration = new Configuration();
        configuration.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
        ResourceUtils.resetResourceTypes((Configuration)configuration);
    }

    private static CustomResourceTypes createCustomResourceTypes(int count, String units) {
        List<String> resourceNames = CustomResourceTypesConfigurationProvider.generateResourceTypeNames(count);
        Map<String, String> resourcesWithUnits = resourceNames.stream().collect(Collectors.toMap(e -> e, e -> units));
        return CustomResourceTypesConfigurationProvider.createCustomResourceTypes(resourcesWithUnits);
    }

    private static CustomResourceTypes createCustomResourceTypes(Map<String, String> resourcesWithUnits) {
        int count = resourcesWithUnits.size();
        ArrayList resourceNames = Lists.newArrayList(resourcesWithUnits.keySet());
        List resourceUnitXmlElements = IntStream.range(0, count).boxed().map(i -> CustomResourceTypesConfigurationProvider.getResourceUnitsXml((String)resourceNames.get((int)i), (String)resourcesWithUnits.get(resourceNames.get((int)i)))).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder("<configuration>\n");
        sb.append(CustomResourceTypesConfigurationProvider.getResourceTypesXml(resourceNames));
        for (String resourceUnitXml : resourceUnitXmlElements) {
            sb.append(resourceUnitXml);
        }
        sb.append("</configuration>");
        return new CustomResourceTypes(sb.toString(), count);
    }

    private static List<String> generateResourceTypeNames(int count) {
        return IntStream.range(0, count).boxed().map(i -> CUSTOM_RESOURCE_PREFIX + (i + 1)).collect(Collectors.toList());
    }

    private static String getResourceUnitsXml(String resource, String units) {
        return "<property>\n<name>yarn.resource-types." + resource + ".units</name>\n<value>" + units + "</value>\n</property>\n";
    }

    private static String getResourceTypesXml(List<String> resources) {
        String resourceTypes = String.join((CharSequence)",", resources);
        return "<property>\n<name>yarn.resource-types</name>\n<value>" + resourceTypes + "</value>\n</property>\n";
    }

    public static void reset() {
        customResourceTypes = CustomResourceTypesConfigurationProvider.createCustomResourceTypes(2, UNIT_KILO);
    }

    public static void setResourceTypes(int count, String units) {
        customResourceTypes = CustomResourceTypesConfigurationProvider.createCustomResourceTypes(count, units);
    }

    public static void setResourceTypes(Map<String, String> resourcesWithUnits) {
        customResourceTypes = CustomResourceTypesConfigurationProvider.createCustomResourceTypes(resourcesWithUnits);
    }

    public static List<String> getCustomResourceTypes() {
        return CustomResourceTypesConfigurationProvider.generateResourceTypeNames(customResourceTypes.getCount());
    }

    private static class CustomResourceTypes {
        private int count;
        private String xml;

        CustomResourceTypes(String xml, int count) {
            this.xml = xml;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getXml() {
            return this.xml;
        }
    }
}

