/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.registry.server.dns;

import org.apache.hadoop.registry.client.types.ServiceRecord;

import java.io.IOException;

/**
 *  Manage the processing of service records in order to create DNS records.
 */
public interface ServiceRecordProcessor {
  /**
   * Initialize the mapping between DNS record type and record information
   * for the given service record.
   * @param serviceRecord  the registry service record.
   * @throws Exception if encountering an error.
   */
  void initTypeToInfoMapping(ServiceRecord serviceRecord)
      throws Exception;

  /**
   * Return the DNS record types valid for this processor.
   * @return  the array of DNS record types.
   */
  int[] getRecordTypes();

  /**
   * Manage the creation and registration of DNS records generated by parsing
   * a service record.
   * @param command  the DNS registration command object (e.g. add_record,
   *                 remove record)
   * @throws IOException if the creation or registration generates an issue.
   */
  void manageDNSRecords(RegistryDNS.RegistryCommand command)
      throws IOException;

}
