/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.metrics;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(about="Performance and usage metrics for Federation StateStore", context="fedr")
public final class FederationStateStoreClientMetrics
implements MetricsSource {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreClientMetrics.class);
    private static final MetricsRegistry REGISTRY = new MetricsRegistry("FederationStateStoreClientMetrics");
    private static final Method[] STATESTORE_API_METHODS = FederationStateStore.class.getMethods();
    private static final Map<String, MutableCounterLong> API_TO_FAILED_CALLS = new HashMap<String, MutableCounterLong>();
    private static final Map<String, MutableRate> API_TO_SUCCESSFUL_CALLS = new HashMap<String, MutableRate>();
    private static final Map<String, MutableQuantiles> API_TO_QUANTILE_METRICS = new HashMap<String, MutableQuantiles>();
    private static final String UNKOWN_FAIL_ERROR_MSG = "Not recording failed call for unknown FederationStateStore method {}";
    private static final String UNKNOWN_SUCCESS_ERROR_MSG = "Not recording successful call for unknown FederationStateStore method {}";
    @Metric(value={"Total number of successful calls and latency(ms)"})
    private static MutableRate totalSucceededCalls;
    @Metric(value={"Total number of failed StateStore calls"})
    private static MutableCounterLong totalFailedCalls;
    private static final FederationStateStoreClientMetrics S_INSTANCE;

    public static synchronized FederationStateStoreClientMetrics getInstance() {
        return S_INSTANCE;
    }

    private FederationStateStoreClientMetrics() {
        for (Method m : STATESTORE_API_METHODS) {
            String methodName = m.getName();
            LOG.debug("Registering Federation StateStore Client metrics for {}", (Object)methodName);
            API_TO_FAILED_CALLS.put(methodName, REGISTRY.newCounter(methodName + "_numFailedCalls", "# failed calls to " + methodName, 0L));
            API_TO_SUCCESSFUL_CALLS.put(methodName, REGISTRY.newRate(methodName + "_successfulCalls", "# successful calls and latency(ms) for" + methodName));
            API_TO_QUANTILE_METRICS.put(methodName, REGISTRY.newQuantiles(methodName + "Latency", "Quantile latency (ms) for " + methodName, "ops", "latency", 10));
        }
    }

    public static void failedStateStoreCall() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        MutableCounterLong methodMetric = API_TO_FAILED_CALLS.get(methodName);
        if (methodMetric == null) {
            LOG.error(UNKOWN_FAIL_ERROR_MSG, (Object)methodName);
            return;
        }
        totalFailedCalls.incr();
        methodMetric.incr();
    }

    public static void succeededStateStoreCall(long duration) {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        MutableRate methodMetric = API_TO_SUCCESSFUL_CALLS.get(methodName);
        MutableQuantiles methodQuantileMetric = API_TO_QUANTILE_METRICS.get(methodName);
        if (methodMetric == null || methodQuantileMetric == null) {
            LOG.error(UNKNOWN_SUCCESS_ERROR_MSG, (Object)methodName);
            return;
        }
        totalSucceededCalls.add(duration);
        methodMetric.add(duration);
        methodQuantileMetric.add(duration);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        REGISTRY.snapshot(collector.addRecord(REGISTRY.info()), all);
    }

    @VisibleForTesting
    static long getNumFailedCallsForMethod(String methodName) {
        return API_TO_FAILED_CALLS.get(methodName).value();
    }

    @VisibleForTesting
    static long getNumSucceessfulCallsForMethod(String methodName) {
        return API_TO_SUCCESSFUL_CALLS.get(methodName).lastStat().numSamples();
    }

    @VisibleForTesting
    static double getLatencySucceessfulCallsForMethod(String methodName) {
        return API_TO_SUCCESSFUL_CALLS.get(methodName).lastStat().mean();
    }

    @VisibleForTesting
    static long getNumFailedCalls() {
        return totalFailedCalls.value();
    }

    @VisibleForTesting
    static long getNumSucceededCalls() {
        return totalSucceededCalls.lastStat().numSamples();
    }

    @VisibleForTesting
    static double getLatencySucceededCalls() {
        return totalSucceededCalls.lastStat().mean();
    }

    static {
        S_INSTANCE = (FederationStateStoreClientMetrics)DefaultMetricsSystem.instance().register((Object)new FederationStateStoreClientMetrics());
    }
}

