/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalCacheDirectoryManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceReleaseEvent;

class LocalResourcesTrackerImpl
implements LocalResourcesTracker {
    static final Log LOG = LogFactory.getLog(LocalResourcesTrackerImpl.class);
    private static final String RANDOM_DIR_REGEX = "-?\\d+";
    private static final Pattern RANDOM_DIR_PATTERN = Pattern.compile("-?\\d+");
    private final String user;
    private final Dispatcher dispatcher;
    private final ConcurrentMap<LocalResourceRequest, LocalizedResource> localrsrc;
    private Configuration conf;
    private final boolean useLocalCacheDirectoryManager;
    private ConcurrentHashMap<Path, LocalCacheDirectoryManager> directoryManagers;
    private ConcurrentHashMap<LocalResourceRequest, Path> inProgressLocalResourcesMap;
    private AtomicLong uniqueNumberGenerator = new AtomicLong(9L);

    public LocalResourcesTrackerImpl(String user, Dispatcher dispatcher, boolean useLocalCacheDirectoryManager, Configuration conf) {
        this(user, dispatcher, new ConcurrentHashMap<LocalResourceRequest, LocalizedResource>(), useLocalCacheDirectoryManager, conf);
    }

    LocalResourcesTrackerImpl(String user, Dispatcher dispatcher, ConcurrentMap<LocalResourceRequest, LocalizedResource> localrsrc, boolean useLocalCacheDirectoryManager, Configuration conf) {
        this.user = user;
        this.dispatcher = dispatcher;
        this.localrsrc = localrsrc;
        this.useLocalCacheDirectoryManager = useLocalCacheDirectoryManager;
        if (this.useLocalCacheDirectoryManager) {
            this.directoryManagers = new ConcurrentHashMap();
            this.inProgressLocalResourcesMap = new ConcurrentHashMap();
        }
        this.conf = conf;
    }

    public synchronized void handle(ResourceEvent event) {
        LocalResourceRequest req = event.getLocalResourceRequest();
        LocalizedResource rsrc = (LocalizedResource)this.localrsrc.get(req);
        switch ((ResourceEventType)event.getType()) {
            case LOCALIZED: {
                if (!this.useLocalCacheDirectoryManager) break;
                this.inProgressLocalResourcesMap.remove(req);
                break;
            }
            case REQUEST: {
                if (rsrc != null && !this.isResourcePresent(rsrc)) {
                    LOG.info((Object)("Resource " + rsrc.getLocalPath() + " is missing, localizing it again"));
                    this.localrsrc.remove(req);
                    this.decrementFileCountForLocalCacheDirectory(req, rsrc);
                    rsrc = null;
                }
                if (null != rsrc) break;
                rsrc = new LocalizedResource(req, this.dispatcher);
                this.localrsrc.put(req, rsrc);
                break;
            }
            case RELEASE: {
                if (null != rsrc) break;
                ResourceReleaseEvent relEvent = (ResourceReleaseEvent)event;
                LOG.info((Object)("Container " + relEvent.getContainer() + " sent RELEASE event on a resource request " + req + " not present in cache."));
                return;
            }
            case LOCALIZATION_FAILED: {
                this.decrementFileCountForLocalCacheDirectory(req, null);
                this.localrsrc.remove(req);
            }
        }
        rsrc.handle(event);
    }

    private void decrementFileCountForLocalCacheDirectory(LocalResourceRequest req, LocalizedResource rsrc) {
        if (this.useLocalCacheDirectoryManager) {
            Path rsrcPath = null;
            if (this.inProgressLocalResourcesMap.containsKey(req)) {
                rsrcPath = this.inProgressLocalResourcesMap.remove(req);
            } else if (rsrc != null && rsrc.getLocalPath() != null) {
                rsrcPath = rsrc.getLocalPath().getParent().getParent();
            }
            if (rsrcPath != null) {
                Path parentPath = new Path(rsrcPath.toUri().getRawPath());
                while (!this.directoryManagers.containsKey(parentPath)) {
                    if ((parentPath = parentPath.getParent()) != null) continue;
                    return;
                }
                if (parentPath != null) {
                    String parentDir = parentPath.toUri().getRawPath().toString();
                    LocalCacheDirectoryManager dir = this.directoryManagers.get(parentPath);
                    String rsrcDir = rsrcPath.toUri().getRawPath();
                    if (rsrcDir.equals(parentDir)) {
                        dir.decrementFileCountForPath("");
                    } else {
                        dir.decrementFileCountForPath(rsrcDir.substring(parentDir.length() + 1));
                    }
                }
            }
        }
    }

    public boolean isResourcePresent(LocalizedResource rsrc) {
        File file;
        boolean ret = true;
        if (rsrc.getState() == ResourceState.LOCALIZED && !(file = new File(rsrc.getLocalPath().toUri().getRawPath().toString())).exists()) {
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean contains(LocalResourceRequest resource) {
        return this.localrsrc.containsKey(resource);
    }

    @Override
    public boolean remove(LocalizedResource rem, DeletionService delService) {
        LocalizedResource rsrc = (LocalizedResource)this.localrsrc.get(rem.getRequest());
        if (null == rsrc) {
            LOG.error((Object)("Attempt to remove absent resource: " + rem.getRequest() + " from " + this.getUser()));
            return true;
        }
        if (rsrc.getRefCount() > 0 || ResourceState.DOWNLOADING.equals((Object)rsrc.getState()) || rsrc != rem) {
            LOG.error((Object)("Attempt to remove resource: " + rsrc + " with non-zero refcount"));
            return false;
        }
        this.localrsrc.remove(rem.getRequest());
        if (ResourceState.LOCALIZED.equals((Object)rsrc.getState())) {
            delService.delete(this.getUser(), this.getPathToDelete(rsrc.getLocalPath()), new Path[0]);
        }
        this.decrementFileCountForLocalCacheDirectory(rem.getRequest(), rsrc);
        return true;
    }

    private Path getPathToDelete(Path localPath) {
        Path delPath = localPath.getParent();
        String name = delPath.getName();
        Matcher matcher = RANDOM_DIR_PATTERN.matcher(name);
        if (matcher.matches()) {
            return delPath;
        }
        LOG.warn((Object)"Random directory component did not match. Deleting localized path only");
        return localPath;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Iterator<LocalizedResource> iterator() {
        return this.localrsrc.values().iterator();
    }

    @Override
    public Path getPathForLocalization(LocalResourceRequest req, Path localDirPath) {
        if (this.useLocalCacheDirectoryManager && localDirPath != null) {
            if (!this.directoryManagers.containsKey(localDirPath)) {
                this.directoryManagers.putIfAbsent(localDirPath, new LocalCacheDirectoryManager(this.conf));
            }
            LocalCacheDirectoryManager dir = this.directoryManagers.get(localDirPath);
            Path rPath = localDirPath;
            String hierarchicalPath = dir.getRelativePathForLocalization();
            if (!hierarchicalPath.isEmpty()) {
                rPath = new Path(localDirPath, hierarchicalPath);
            }
            this.inProgressLocalResourcesMap.put(req, rPath);
            return rPath;
        }
        return localDirPath;
    }

    @Override
    public long nextUniqueNumber() {
        return this.uniqueNumberGenerator.incrementAndGet();
    }

    @Override
    @VisibleForTesting
    @InterfaceAudience.Private
    public LocalizedResource getLocalizedResource(LocalResourceRequest request) {
        return (LocalizedResource)this.localrsrc.get(request);
    }
}

