/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.mortbay.log.Log;

public class ContainerLogsPage
extends NMView {
    public static final String REDIRECT_URL = "redirect.url";

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        String redirectUrl = this.$(REDIRECT_URL);
        if (redirectUrl == null || redirectUrl.isEmpty()) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Logs for ", this.$("container.id")}));
        } else if (redirectUrl.equals("false")) {
            this.set("title", StringHelper.join((Object[])new Object[]{"Failed redirect for ", this.$("container.id")}));
        } else {
            this.set("title", StringHelper.join((Object[])new Object[]{"Redirecting to log server for ", this.$("container.id")}));
            html.meta_http("refresh", "1; url=" + redirectUrl);
        }
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return ContainersLogsBlock.class;
    }

    public static class ContainersLogsBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Configuration conf;
        private final Context nmContext;
        private final ApplicationACLsManager aclsManager;
        private final LocalDirsHandlerService dirsHandler;

        @Inject
        public ContainersLogsBlock(Configuration conf, Context context, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
            this.conf = conf;
            this.nmContext = context;
            this.aclsManager = aclsManager;
            this.dirsHandler = dirsHandler;
        }

        protected void render(HtmlBlock.Block html) {
            ContainerId containerId;
            String redirectUrl = this.$(ContainerLogsPage.REDIRECT_URL);
            if (redirectUrl != null && redirectUrl.equals("false")) {
                html.h1("Failed while trying to construct the redirect url to the log server. Log Server url may not be configured");
            }
            try {
                containerId = ConverterUtils.toContainerId((String)this.$("container.id"));
            }
            catch (IllegalArgumentException e) {
                html.h1("Invalid containerId " + this.$("container.id"));
                return;
            }
            ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
            Application application = (Application)this.nmContext.getApplications().get(applicationId);
            Container container = (Container)this.nmContext.getContainers().get(containerId);
            if (application == null) {
                html.h1("Unknown container. Container either has not started or has already completed or doesn't belong to this node at all.");
                return;
            }
            if (container == null) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (EnumSet.of(ContainerState.NEW, ContainerState.LOCALIZING, ContainerState.LOCALIZED).contains((Object)container.getContainerState())) {
                html.h1("Container is not yet running. Current state is " + (Object)((Object)container.getContainerState()));
                return;
            }
            if (container.getContainerState() == ContainerState.LOCALIZATION_FAILED) {
                html.h1("Container wasn't started. Localization failed.");
                return;
            }
            if (EnumSet.of(ContainerState.RUNNING, ContainerState.EXITED_WITH_FAILURE, ContainerState.EXITED_WITH_SUCCESS).contains((Object)container.getContainerState())) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (EnumSet.of(ContainerState.KILLING, ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerState.CONTAINER_RESOURCES_CLEANINGUP).contains((Object)container.getContainerState())) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            if (container.getContainerState().equals((Object)ContainerState.DONE)) {
                this.printLogs(html, containerId, applicationId, application);
                return;
            }
            html.h1("Container is no longer running...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printLogs(HtmlBlock.Block html, ContainerId containerId, ApplicationId applicationId, Application application) {
            String remoteUser = this.request().getRemoteUser();
            UserGroupInformation callerUGI = null;
            if (remoteUser != null) {
                callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
            }
            if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, application.getUser(), applicationId)) {
                html.h1("User [" + remoteUser + "] is not authorized to view the logs for application " + applicationId);
                return;
            }
            if (!this.$("log.type").isEmpty()) {
                File logFile = null;
                try {
                    URI logPathURI = new URI(this.dirsHandler.getLogPathToRead(ContainerLaunch.getRelativeContainerLogDir(applicationId.toString(), containerId.toString()) + "/" + this.$("log.type")).toString());
                    logFile = new File(logPathURI.getPath());
                }
                catch (URISyntaxException e) {
                    html.h1("Cannot find this log on the local disk.");
                    return;
                }
                catch (Exception e) {
                    html.h1("Cannot find this log on the local disk.");
                    return;
                }
                long start = this.$("start").isEmpty() ? -4096L : Long.parseLong(this.$("start"));
                start = start < 0L ? logFile.length() + start : start;
                start = start < 0L ? 0L : start;
                long end = this.$("end").isEmpty() ? logFile.length() : Long.parseLong(this.$("end"));
                end = end < 0L ? logFile.length() + end : end;
                long l = end = end < 0L ? logFile.length() : end;
                if (start > end) {
                    html.h1("Invalid start and end values. Start: [" + start + "]" + ", end[" + end + "]");
                    return;
                }
                FileInputStream logByteStream = null;
                try {
                    logByteStream = SecureIOUtils.openForRead((File)logFile, (String)application.getUser(), null);
                }
                catch (IOException e) {
                    LOG.error("Exception reading log file " + logFile.getAbsolutePath(), (Throwable)e);
                    if (e.getMessage().contains("did not match expected owner '" + application.getUser() + "'")) {
                        html.h1("Exception reading log file. Application submitted by '" + application.getUser() + "' doesn't own requested log file : " + logFile.getName());
                    } else {
                        html.h1("Exception reading log file. It might be because log file was aggregated : " + logFile.getName());
                    }
                    return;
                }
                try {
                    long toRead = end - start;
                    if (toRead < logFile.length()) {
                        html.p()._(new Object[]{"Showing " + toRead + " bytes. Click "}).a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), logFile.getName(), "?start=0"}), "here")._(new Object[]{" for full log"})._();
                    }
                    IOUtils.skipFully((InputStream)logByteStream, (long)start);
                    InputStreamReader reader = new InputStreamReader(logByteStream);
                    int bufferSize = 65536;
                    char[] cbuf = new char[bufferSize];
                    int len = 0;
                    int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                    Hamlet.PRE pre = html.pre();
                    while ((len = reader.read(cbuf, 0, currentToRead)) > 0 && toRead > 0L) {
                        pre._(new Object[]{new String(cbuf, 0, len)});
                        currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                    }
                    pre._();
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error("Exception reading log file " + logFile.getAbsolutePath(), (Throwable)e);
                    html.h1("Exception reading log file. It might be because log file was aggregated : " + logFile.getName());
                }
                finally {
                    if (logByteStream != null) {
                        try {
                            logByteStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            } else {
                List<File> containerLogsDirs = ContainersLogsBlock.getContainerLogDirs(containerId, this.dirsHandler);
                Collections.sort(containerLogsDirs);
                boolean foundLogFile = false;
                for (File containerLogsDir : containerLogsDirs) {
                    Object[] logFiles = containerLogsDir.listFiles();
                    if (logFiles == null) continue;
                    Arrays.sort(logFiles);
                    for (Object logFile : logFiles) {
                        foundLogFile = true;
                        html.p().a(this.url(new String[]{"containerlogs", this.$("container.id"), this.$("app.owner"), ((File)logFile).getName(), "?start=-4096"}), ((File)logFile).getName() + " : Total file length is " + ((File)logFile).length() + " bytes.")._();
                    }
                }
                if (!foundLogFile) {
                    html.h1("No logs available for container " + containerId.toString());
                    return;
                }
            }
        }

        static List<File> getContainerLogDirs(ContainerId containerId, LocalDirsHandlerService dirsHandler) {
            List<String> logDirs = dirsHandler.getLogDirs();
            ArrayList<File> containerLogDirs = new ArrayList<File>(logDirs.size());
            for (String logDir : logDirs) {
                try {
                    logDir = new URI(logDir).getPath();
                }
                catch (URISyntaxException e) {
                    Log.warn((String)e.getMessage());
                }
                String appIdStr = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
                File appLogDir = new File(logDir, appIdStr);
                String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
                containerLogDirs.add(new File(appLogDir, containerIdStr));
            }
            return containerLogDirs;
        }
    }
}

