/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DefaultContainerExecutor
extends ContainerExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultContainerExecutor.class);
    private static final int WIN_MAX_PATH = 260;
    protected final FileContext lfs;
    static final short USER_PERM = 488;
    static final short APPCACHE_PERM = 456;
    static final short FILECACHE_PERM = 456;
    static final short APPDIR_PERM = 456;
    static final short LOGDIR_PERM = 456;

    public DefaultContainerExecutor() {
        try {
            this.lfs = FileContext.getLocalFSFileContext();
        }
        catch (UnsupportedFileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    DefaultContainerExecutor(FileContext lfs) {
        this.lfs = lfs;
    }

    protected void copyFile(Path src, Path dst, String owner) throws IOException {
        this.lfs.util().copy(src, dst);
    }

    protected void setScriptExecutable(Path script, String owner) throws IOException {
        this.lfs.setPermission(script, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
    }

    @Override
    public void init() throws IOException {
    }

    @Override
    public void startLocalizer(Path nmPrivateContainerTokensPath, InetSocketAddress nmAddr, String user, String appId, String locId, LocalDirsHandlerService dirsHandler) throws IOException, InterruptedException {
        List<String> localDirs = dirsHandler.getLocalDirs();
        List<String> logDirs = dirsHandler.getLogDirs();
        this.createUserLocalDirs(localDirs, user);
        this.createUserCacheDirs(localDirs, user);
        this.createAppDirs(localDirs, user, appId);
        this.createAppLogDirs(appId, logDirs, user);
        Path appStorageDir = this.getWorkingDir(localDirs, user, appId);
        String tokenFn = String.format("%s.tokens", locId);
        Path tokenDst = new Path(appStorageDir, tokenFn);
        this.copyFile(nmPrivateContainerTokensPath, tokenDst, user);
        LOG.info((Object)("Copying from " + nmPrivateContainerTokensPath + " to " + tokenDst));
        FileContext localizerFc = FileContext.getFileContext((AbstractFileSystem)this.lfs.getDefaultFileSystem(), (Configuration)this.getConf());
        localizerFc.setUMask(this.lfs.getUMask());
        localizerFc.setWorkingDirectory(appStorageDir);
        LOG.info((Object)("Localizer CWD set to " + appStorageDir + " = " + localizerFc.getWorkingDirectory()));
        ContainerLocalizer localizer = new ContainerLocalizer(localizerFc, user, appId, locId, DefaultContainerExecutor.getPaths(localDirs), RecordFactoryProvider.getRecordFactory((Configuration)this.getConf()));
        localizer.runLocalization(nmAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int launchContainer(Container container, Path nmPrivateContainerScriptPath, Path nmPrivateTokensPath, String user, String appId, Path containerWorkDir, List<String> localDirs, List<String> logDirs) throws IOException {
        block16: {
            FsPermission dirPerm = new FsPermission(456);
            ContainerId containerId = container.getContainerId();
            String containerIdStr = ConverterUtils.toString((ContainerId)containerId);
            String appIdStr = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
            for (String sLocalDir : localDirs) {
                Path usersdir = new Path(sLocalDir, "usercache");
                Path userdir = new Path(usersdir, user);
                Path appCacheDir = new Path(userdir, "appcache");
                Path appDir = new Path(appCacheDir, appIdStr);
                Path containerDir = new Path(appDir, containerIdStr);
                this.createDir(containerDir, dirPerm, true, user);
            }
            this.createContainerLogDirs(appIdStr, containerIdStr, logDirs, user);
            Path tmpDir = new Path(containerWorkDir, "./tmp");
            this.createDir(tmpDir, dirPerm, false, user);
            Path tokenDst = new Path(containerWorkDir, "container_tokens");
            this.copyFile(nmPrivateTokensPath, tokenDst, user);
            Path launchDst = new Path(containerWorkDir, ContainerLaunch.CONTAINER_SCRIPT);
            this.copyFile(nmPrivateContainerScriptPath, launchDst, user);
            LocalWrapperScriptBuilder sb = this.getLocalWrapperScriptBuilder(containerIdStr, containerWorkDir);
            if (Shell.WINDOWS && sb.getWrapperScriptPath().toString().length() > 260) {
                throw new IOException(String.format("Cannot launch container using script at path %s, because it exceeds the maximum supported path length of %d characters.  Consider configuring shorter directories in %s.", sb.getWrapperScriptPath(), 260, "yarn.nodemanager.local-dirs"));
            }
            Path pidFile = this.getPidFilePath(containerId);
            if (pidFile == null) {
                LOG.info((Object)("Container " + containerIdStr + " was marked as inactive. Returning terminated error"));
                return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            }
            sb.writeLocalWrapperScript(launchDst, pidFile);
            try (Shell.CommandExecutor shExec = null;){
                this.setScriptExecutable(launchDst, user);
                this.setScriptExecutable(sb.getWrapperScriptPath(), user);
                shExec = this.buildCommandExecutor(sb.getWrapperScriptPath().toString(), containerIdStr, user, pidFile, container.getResource(), new File(containerWorkDir.toUri().getPath()), container.getLaunchContext().getEnvironment());
                if (this.isContainerActive(containerId)) {
                    shExec.execute();
                    break block16;
                }
                LOG.info((Object)("Container " + containerIdStr + " was marked as inactive. Returning terminated error"));
                int containerDir = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return containerDir;
            }
        }
        return 0;
    }

    protected Shell.CommandExecutor buildCommandExecutor(String wrapperScriptPath, String containerIdStr, String user, Path pidFile, Resource resource, File wordDir, Map<String, String> environment) throws IOException {
        Object[] command = this.getRunCommand(wrapperScriptPath, containerIdStr, user, pidFile, this.getConf(), resource);
        LOG.info((Object)("launchContainer: " + Arrays.toString(command)));
        return new Shell.ShellCommandExecutor((String[])command, wordDir, environment);
    }

    protected LocalWrapperScriptBuilder getLocalWrapperScriptBuilder(String containerIdStr, Path containerWorkDir) {
        return Shell.WINDOWS ? new WindowsLocalWrapperScriptBuilder(containerIdStr, containerWorkDir) : new UnixLocalWrapperScriptBuilder(containerWorkDir);
    }

    @Override
    public boolean signalContainer(String user, String pid, ContainerExecutor.Signal signal) throws IOException {
        LOG.debug((Object)("Sending signal " + signal.getValue() + " to pid " + pid + " as user " + user));
        if (!DefaultContainerExecutor.containerIsAlive(pid)) {
            return false;
        }
        try {
            this.killContainer(pid, signal);
        }
        catch (IOException e) {
            if (!DefaultContainerExecutor.containerIsAlive(pid)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public boolean isContainerProcessAlive(String user, String pid) throws IOException {
        return DefaultContainerExecutor.containerIsAlive(pid);
    }

    @VisibleForTesting
    public static boolean containerIsAlive(String pid) throws IOException {
        try {
            new Shell.ShellCommandExecutor(Shell.getCheckProcessIsAliveCommand((String)pid)).execute();
            return true;
        }
        catch (Shell.ExitCodeException e) {
            return false;
        }
    }

    protected void killContainer(String pid, ContainerExecutor.Signal signal) throws IOException {
        new Shell.ShellCommandExecutor(Shell.getSignalKillCommand((int)signal.getValue(), (String)pid)).execute();
    }

    @Override
    public void deleteAsUser(String user, Path subDir, Path ... baseDirs) throws IOException, InterruptedException {
        if (baseDirs == null || baseDirs.length == 0) {
            LOG.info((Object)("Deleting absolute path : " + subDir));
            if (!this.lfs.delete(subDir, true)) {
                LOG.warn((Object)("delete returned false for path: [" + subDir + "]"));
            }
            return;
        }
        for (Path baseDir : baseDirs) {
            Path del = subDir == null ? baseDir : new Path(baseDir, subDir);
            LOG.info((Object)("Deleting path : " + del));
            if (this.lfs.delete(del, true)) continue;
            LOG.warn((Object)("delete returned false for path: [" + del + "]"));
        }
    }

    private long getDiskFreeSpace(Path base) throws IOException {
        return this.lfs.getFsStatus(base).getRemaining();
    }

    private Path getApplicationDir(Path base, String user, String appId) {
        return new Path(this.getAppcacheDir(base, user), appId);
    }

    private Path getUserCacheDir(Path base, String user) {
        return new Path(new Path(base, "usercache"), user);
    }

    private Path getAppcacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "appcache");
    }

    private Path getFileCacheDir(Path base, String user) {
        return new Path(this.getUserCacheDir(base, user), "filecache");
    }

    protected Path getWorkingDir(List<String> localDirs, String user, String appId) throws IOException {
        Path appStorageDir = null;
        long totalAvailable = 0L;
        long[] availableOnDisk = new long[localDirs.size()];
        int i = 0;
        for (String localDir : localDirs) {
            Path curBase = this.getApplicationDir(new Path(localDir), user, appId);
            long space = 0L;
            try {
                space = this.getDiskFreeSpace(curBase);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to get Free Space for " + curBase.toString()), (Throwable)e);
            }
            availableOnDisk[i++] = space;
            totalAvailable += space;
        }
        if (totalAvailable <= 0L) {
            throw new IOException("Not able to find a working directory for " + user);
        }
        long randomPosition = RandomUtils.nextLong() % totalAvailable;
        int dir = 0;
        while (availableOnDisk[dir] == 0L) {
            ++dir;
        }
        while (randomPosition > availableOnDisk[dir]) {
            randomPosition -= availableOnDisk[dir++];
        }
        appStorageDir = this.getApplicationDir(new Path(localDirs.get(dir)), user, appId);
        return appStorageDir;
    }

    protected void createDir(Path dirPath, FsPermission perms, boolean createParent, String user) throws IOException {
        this.lfs.mkdir(dirPath, perms, createParent);
        if (!perms.equals((Object)perms.applyUMask(this.lfs.getUMask()))) {
            this.lfs.setPermission(dirPath, perms);
        }
    }

    void createUserLocalDirs(List<String> localDirs, String user) throws IOException {
        boolean userDirStatus = false;
        FsPermission userperms = new FsPermission(488);
        for (String localDir : localDirs) {
            try {
                this.createDir(this.getUserCacheDir(new Path(localDir), user), userperms, true, user);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the user directory : " + localDir), (Throwable)e);
                continue;
            }
            userDirStatus = true;
        }
        if (!userDirStatus) {
            throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
        }
    }

    void createUserCacheDirs(List<String> localDirs, String user) throws IOException {
        LOG.info((Object)("Initializing user " + user));
        boolean appcacheDirStatus = false;
        boolean distributedCacheDirStatus = false;
        FsPermission appCachePerms = new FsPermission(456);
        FsPermission fileperms = new FsPermission(456);
        for (String localDir : localDirs) {
            Path localDirPath = new Path(localDir);
            Path appDir = this.getAppcacheDir(localDirPath, user);
            try {
                this.createDir(appDir, appCachePerms, true, user);
                appcacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create app cache directory : " + appDir), (Throwable)e);
            }
            Path distDir = this.getFileCacheDir(localDirPath, user);
            try {
                this.createDir(distDir, fileperms, true, user);
                distributedCacheDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create file cache directory : " + distDir), (Throwable)e);
            }
        }
        if (!appcacheDirStatus) {
            throw new IOException("Not able to initialize app-cache directories in any of the configured local directories for user " + user);
        }
        if (!distributedCacheDirStatus) {
            throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
        }
    }

    void createAppDirs(List<String> localDirs, String user, String appId) throws IOException {
        boolean initAppDirStatus = false;
        FsPermission appperms = new FsPermission(456);
        for (String localDir : localDirs) {
            Path fullAppDir = this.getApplicationDir(new Path(localDir), user, appId);
            try {
                this.createDir(fullAppDir, appperms, true, user);
                initAppDirStatus = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create app directory " + fullAppDir.toString()), (Throwable)e);
            }
        }
        if (!initAppDirStatus) {
            throw new IOException("Not able to initialize app directories in any of the configured local directories for app " + appId.toString());
        }
    }

    void createAppLogDirs(String appId, List<String> logDirs, String user) throws IOException {
        boolean appLogDirStatus = false;
        FsPermission appLogDirPerms = new FsPermission(456);
        for (String rootLogDir : logDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            try {
                this.createDir(appLogDir, appLogDirPerms, true, user);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the app-log directory : " + appLogDir), (Throwable)e);
                continue;
            }
            appLogDirStatus = true;
        }
        if (!appLogDirStatus) {
            throw new IOException("Not able to initialize app-log directories in any of the configured local directories for app " + appId);
        }
    }

    void createContainerLogDirs(String appId, String containerId, List<String> logDirs, String user) throws IOException {
        boolean containerLogDirStatus = false;
        FsPermission containerLogDirPerms = new FsPermission(456);
        for (String rootLogDir : logDirs) {
            Path appLogDir = new Path(rootLogDir, appId);
            Path containerLogDir = new Path(appLogDir, containerId);
            try {
                this.createDir(containerLogDir, containerLogDirPerms, true, user);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create the container-log directory : " + appLogDir), (Throwable)e);
                continue;
            }
            containerLogDirStatus = true;
        }
        if (!containerLogDirStatus) {
            throw new IOException("Not able to initialize container-log directories in any of the configured local directories for container " + containerId);
        }
    }

    private static List<Path> getPaths(List<String> dirs) {
        ArrayList<Path> paths = new ArrayList<Path>(dirs.size());
        for (int i = 0; i < dirs.size(); ++i) {
            paths.add(new Path(dirs.get(i)));
        }
        return paths;
    }

    private final class WindowsLocalWrapperScriptBuilder
    extends LocalWrapperScriptBuilder {
        private final String containerIdStr;

        public WindowsLocalWrapperScriptBuilder(String containerIdStr, Path containerWorkDir) {
            super(containerWorkDir);
            this.containerIdStr = containerIdStr;
        }

        @Override
        public void writeLocalWrapperScript(Path launchDst, Path pidFile, PrintStream pout) {
            String normalizedPidFile = new File(pidFile.toString()).getPath();
            pout.println("@echo " + this.containerIdStr + " > " + normalizedPidFile + ".tmp");
            pout.println("@move /Y " + normalizedPidFile + ".tmp " + normalizedPidFile);
            pout.println("@call " + launchDst.toString());
        }
    }

    private final class UnixLocalWrapperScriptBuilder
    extends LocalWrapperScriptBuilder {
        private final Path sessionScriptPath;

        public UnixLocalWrapperScriptBuilder(Path containerWorkDir) {
            super(containerWorkDir);
            this.sessionScriptPath = new Path(containerWorkDir, Shell.appendScriptExtension((String)"default_container_executor_session"));
        }

        @Override
        public void writeLocalWrapperScript(Path launchDst, Path pidFile) throws IOException {
            this.writeSessionScript(launchDst, pidFile);
            super.writeLocalWrapperScript(launchDst, pidFile);
        }

        @Override
        public void writeLocalWrapperScript(Path launchDst, Path pidFile, PrintStream pout) {
            String exitCodeFile = ContainerLaunch.getExitCodeFile(pidFile.toString());
            String tmpFile = exitCodeFile + ".tmp";
            pout.println("#!/bin/bash");
            pout.println("/bin/bash \"" + this.sessionScriptPath.toString() + "\"");
            pout.println("rc=$?");
            pout.println("echo $rc > \"" + tmpFile + "\"");
            pout.println("/bin/mv -f \"" + tmpFile + "\" \"" + exitCodeFile + "\"");
            pout.println("exit $rc");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeSessionScript(Path launchDst, Path pidFile) throws IOException {
            FSDataOutputStream out = null;
            PrintStream pout = null;
            try {
                out = DefaultContainerExecutor.this.lfs.create(this.sessionScriptPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                pout = new PrintStream((OutputStream)out, false, "UTF-8");
                pout.println("#!/bin/bash");
                pout.println();
                pout.println("echo $$ > " + pidFile.toString() + ".tmp");
                pout.println("/bin/mv -f " + pidFile.toString() + ".tmp " + pidFile);
                String exec = Shell.isSetsidAvailable ? "exec setsid" : "exec";
                pout.println(exec + " /bin/bash \"" + launchDst.toUri().getPath().toString() + "\"");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{pout, out});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{pout, out});
            DefaultContainerExecutor.this.lfs.setPermission(this.sessionScriptPath, ContainerExecutor.TASK_LAUNCH_SCRIPT_PERMISSION);
        }
    }

    protected abstract class LocalWrapperScriptBuilder {
        private final Path wrapperScriptPath;

        public Path getWrapperScriptPath() {
            return this.wrapperScriptPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLocalWrapperScript(Path launchDst, Path pidFile) throws IOException {
            FSDataOutputStream out = null;
            PrintStream pout = null;
            try {
                out = DefaultContainerExecutor.this.lfs.create(this.wrapperScriptPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                pout = new PrintStream((OutputStream)out, false, "UTF-8");
                this.writeLocalWrapperScript(launchDst, pidFile, pout);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{pout, out});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{pout, out});
        }

        protected abstract void writeLocalWrapperScript(Path var1, Path var2, PrintStream var3);

        protected LocalWrapperScriptBuilder(Path containerWorkDir) {
            this.wrapperScriptPath = new Path(containerWorkDir, Shell.appendScriptExtension((String)"default_container_executor"));
        }
    }
}

