/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeResourceMonitorImpl
extends AbstractService
implements NodeResourceMonitor {
    static final Logger LOG = LoggerFactory.getLogger(NodeResourceMonitorImpl.class);
    private long monitoringInterval;
    private MonitoringThread monitoringThread;
    private ResourceCalculatorPlugin resourceCalculatorPlugin;
    private ResourceUtilization nodeUtilization = ResourceUtilization.newInstance((int)0, (int)0, (float)0.0f);
    private Context nmContext;

    public NodeResourceMonitorImpl(Context context) {
        super(NodeResourceMonitorImpl.class.getName());
        this.nmContext = context;
        this.monitoringThread = new MonitoringThread();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.monitoringInterval = conf.getLong("yarn.nodemanager.resource-monitor.interval-ms", 3000L);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getNodeResourceMonitorPlugin((Configuration)conf);
        LOG.info(" Using ResourceCalculatorPlugin : " + this.resourceCalculatorPlugin);
    }

    private boolean isEnabled() {
        if (this.monitoringInterval <= 0L) {
            LOG.info("Node Resource monitoring interval is <=0. " + this.getClass().getName() + " is disabled.");
            return false;
        }
        if (this.resourceCalculatorPlugin == null) {
            LOG.info("ResourceCalculatorPlugin is unavailable on this system. " + this.getClass().getName() + " is disabled.");
            return false;
        }
        return true;
    }

    protected void serviceStart() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.interrupt();
            try {
                this.monitoringThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Could not wait for the thread to join");
            }
        }
        super.serviceStop();
    }

    @Override
    public ResourceUtilization getUtilization() {
        return this.nodeUtilization;
    }

    private class MonitoringThread
    extends Thread {
        public MonitoringThread() {
            super("Node Resource Monitor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                long pmem = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getPhysicalMemorySize() - NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getAvailablePhysicalMemorySize();
                long vmem = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getVirtualMemorySize() - NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getAvailableVirtualMemorySize();
                float vcores = NodeResourceMonitorImpl.this.resourceCalculatorPlugin.getNumVCoresUsed();
                NodeResourceMonitorImpl.this.nodeUtilization = ResourceUtilization.newInstance((int)((int)(pmem >> 20)), (int)((int)(vmem >> 20)), (float)vcores);
                NodeManagerMetrics nmMetrics = NodeResourceMonitorImpl.this.nmContext.getNodeManagerMetrics();
                if (nmMetrics != null) {
                    nmMetrics.setNodeUsedMemGB(NodeResourceMonitorImpl.this.nodeUtilization.getPhysicalMemory());
                    nmMetrics.setNodeUsedVMemGB(NodeResourceMonitorImpl.this.nodeUtilization.getVirtualMemory());
                    nmMetrics.setNodeCpuUtilization(NodeResourceMonitorImpl.this.nodeUtilization.getCPU());
                }
                try {
                    Thread.sleep(NodeResourceMonitorImpl.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn(NodeResourceMonitorImpl.class.getName() + " is interrupted. Exiting.");
                    return;
                }
            }
        }
    }
}

