/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class DeletionAsUserContext {
    private final String user;
    private final Path subDir;
    private final List<Path> basedirs;

    private DeletionAsUserContext(Builder builder) {
        this.user = builder.user;
        this.subDir = builder.subDir;
        this.basedirs = builder.basedirs;
    }

    public String getUser() {
        return this.user;
    }

    public Path getSubDir() {
        return this.subDir;
    }

    public List<Path> getBasedirs() {
        if (this.basedirs != null) {
            return Collections.unmodifiableList(this.basedirs);
        }
        return null;
    }

    public static final class Builder {
        private String user;
        private Path subDir;
        private List<Path> basedirs;

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSubDir(Path subDir) {
            this.subDir = subDir;
            return this;
        }

        public Builder setBasedirs(Path ... basedirs) {
            this.basedirs = Arrays.asList(basedirs);
            return this;
        }

        public DeletionAsUserContext build() {
            return new DeletionAsUserContext(this);
        }
    }
}

