/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePluginScheduler;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DeviceRegisterRequest;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DeviceRuntimeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.YarnRuntimeType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec.UdevUtil;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.com.nec.VEDeviceDiscoverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NECVEPlugin
implements DevicePlugin,
DevicePluginScheduler {
    private static final String HADOOP_COMMON_HOME = "HADOOP_COMMON_HOME";
    private static final String ENV_SCRIPT_PATH = "NEC_VE_GET_SCRIPT_PATH";
    private static final String ENV_SCRIPT_NAME = "NEC_VE_GET_SCRIPT_NAME";
    private static final String ENV_USE_UDEV = "NEC_USE_UDEV";
    private static final String DEFAULT_SCRIPT_NAME = "nec-ve-get.py";
    private static final Logger LOG = LoggerFactory.getLogger(NECVEPlugin.class);
    private static final String[] DEFAULT_BINARY_SEARCH_DIRS = new String[]{"/usr/bin", "/bin", "/opt/nec/ve/bin"};
    private String binaryPath;
    private boolean useUdev;
    private VEDeviceDiscoverer discoverer;
    private Function<String[], Shell.CommandExecutor> commandExecutorProvider = this::createCommandExecutor;

    public NECVEPlugin() throws ResourceHandlerException {
        this(System::getenv, DEFAULT_BINARY_SEARCH_DIRS, new UdevUtil());
    }

    @VisibleForTesting
    NECVEPlugin(Function<String, String> envProvider, String[] scriptPaths, UdevUtil udev) throws ResourceHandlerException {
        if (Boolean.parseBoolean(envProvider.apply(ENV_USE_UDEV))) {
            LOG.info("Using libudev to retrieve syspath & device status");
            this.useUdev = true;
            udev.init();
            this.discoverer = new VEDeviceDiscoverer(udev);
        } else {
            this.scriptBasedInit(envProvider, scriptPaths);
        }
    }

    private void scriptBasedInit(Function<String, String> envProvider, String[] scriptPaths) throws ResourceHandlerException {
        String binaryName = DEFAULT_SCRIPT_NAME;
        String envScriptName = envProvider.apply(ENV_SCRIPT_NAME);
        if (envScriptName != null) {
            binaryName = envScriptName;
        }
        LOG.info("Use {} as script name.", (Object)binaryName);
        boolean found = false;
        String envBinaryPath = envProvider.apply(ENV_SCRIPT_PATH);
        if (envBinaryPath != null) {
            this.binaryPath = this.getScriptFromEnvSetting(envBinaryPath);
            boolean bl = found = this.binaryPath != null;
        }
        if (!found) {
            if (envBinaryPath != null) {
                LOG.warn("Script {} does not exist, falling back to $HADOOP_COMMON_HOME/sbin/DevicePluginScript/", (Object)envBinaryPath);
            }
            this.binaryPath = this.getScriptFromHadoopCommon(envProvider, binaryName);
            boolean bl = found = this.binaryPath != null;
        }
        if (!found) {
            LOG.info("Script not found under $HADOOP_COMMON_HOME/sbin/DevicePluginScript/, falling back to default search directories");
            this.binaryPath = this.getScriptFromSearchDirs(binaryName, scriptPaths);
            boolean bl = found = this.binaryPath != null;
        }
        if (!found) {
            LOG.error("Script not found in " + Arrays.toString(scriptPaths));
            throw new ResourceHandlerException("No binary found for " + NECVEPlugin.class.getName());
        }
    }

    @Override
    public DeviceRegisterRequest getRegisterRequestInfo() {
        return DeviceRegisterRequest.Builder.newInstance().setResourceName("nec.com/ve").build();
    }

    @Override
    public Set<Device> getDevices() {
        Set<Device> devices = null;
        if (this.useUdev) {
            try {
                devices = this.discoverer.getDevicesFromPath("/dev");
            }
            catch (IOException e) {
                LOG.error("Error during scanning devices", (Throwable)e);
            }
        } else {
            Shell.CommandExecutor executor = this.commandExecutorProvider.apply(new String[]{this.binaryPath});
            try {
                executor.execute();
                String output = executor.getOutput();
                devices = this.parseOutput(output);
            }
            catch (IOException e) {
                LOG.error("Error during executing external binary", (Throwable)e);
            }
        }
        if (devices != null) {
            LOG.info("Found devices:");
            devices.forEach(dev -> LOG.info("{}", dev));
        }
        return devices;
    }

    @Override
    public DeviceRuntimeSpec onDevicesAllocated(Set<Device> set, YarnRuntimeType yarnRuntimeType) {
        return null;
    }

    private Set<Device> parseOutput(String output) {
        String[] lines;
        HashSet<Device> devices = new HashSet<Device>();
        LOG.info("Parsing output: {}", (Object)output);
        block0: for (String line : lines = output.split("\n")) {
            String[] keyValues;
            Device.Builder builder = Device.Builder.newInstance();
            Map<String, Consumer<String>> builderInvocations = this.getBuilderInvocationsMap(builder);
            for (String keyValue : keyValues = line.trim().split(",")) {
                String[] tokens = keyValue.trim().split("=");
                if (tokens.length != 2) {
                    LOG.error("Unknown format of script output! Skipping this line");
                    continue block0;
                }
                String key = tokens[0];
                String value = tokens[1];
                Consumer<String> builderInvocation = builderInvocations.get(key);
                if (builderInvocation != null) {
                    builderInvocation.accept(value);
                    continue;
                }
                LOG.warn("Unknown key {}, ignored", (Object)key);
            }
            Device device = builder.build();
            if (device.isHealthy()) {
                devices.add(device);
                continue;
            }
            LOG.warn("Skipping device {} because it's not healthy", (Object)device);
        }
        return devices;
    }

    @Override
    public void onDevicesReleased(Set<Device> releasedDevices) {
    }

    @Override
    public Set<Device> allocateDevices(Set<Device> availableDevices, int count, Map<String, String> env) {
        HashSet<Device> allocated = new HashSet<Device>();
        int number = 0;
        for (Device d : availableDevices) {
            allocated.add(d);
            if (++number != count) continue;
            break;
        }
        return allocated;
    }

    private Shell.CommandExecutor createCommandExecutor(String[] command) {
        return new Shell.ShellCommandExecutor(command);
    }

    private String getScriptFromEnvSetting(String envBinaryPath) {
        LOG.info("Checking script path: {}", (Object)envBinaryPath);
        File f = new File(envBinaryPath);
        if (!f.exists()) {
            LOG.warn("Script {} does not exist", (Object)envBinaryPath);
            return null;
        }
        if (f.isDirectory()) {
            LOG.warn("Specified path {} is a directory", (Object)envBinaryPath);
            return null;
        }
        if (!FileUtil.canExecute((File)f)) {
            LOG.warn("Script {} is not executable", (Object)envBinaryPath);
            return null;
        }
        LOG.info("Found script: {}", (Object)envBinaryPath);
        return envBinaryPath;
    }

    private String getScriptFromHadoopCommon(Function<String, String> envProvider, String binaryName) {
        String scriptPath = null;
        String hadoopCommon = envProvider.apply(HADOOP_COMMON_HOME);
        if (hadoopCommon != null) {
            String targetPath = hadoopCommon + "/sbin/DevicePluginScript/" + binaryName;
            LOG.info("Checking script {}: ", (Object)targetPath);
            if (new File(targetPath).exists()) {
                LOG.info("Found script: {}", (Object)targetPath);
                scriptPath = targetPath;
            }
        } else {
            LOG.info("$HADOOP_COMMON_HOME is not set");
        }
        return scriptPath;
    }

    private String getScriptFromSearchDirs(String binaryName, String[] scriptPaths) {
        String scriptPath = null;
        for (String dir : scriptPaths) {
            File f = new File(dir, binaryName);
            if (!f.exists()) continue;
            LOG.info("Found script: {}", (Object)dir);
            scriptPath = f.getAbsolutePath();
            break;
        }
        return scriptPath;
    }

    private Map<String, Consumer<String>> getBuilderInvocationsMap(Device.Builder builder) {
        HashMap<String, Consumer<String>> builderInvocations = new HashMap<String, Consumer<String>>();
        builderInvocations.put("id", v -> builder.setId(Integer.parseInt(v)));
        builderInvocations.put("dev", v -> builder.setDevPath((String)v));
        builderInvocations.put("state", v -> {
            if (v.equals("ONLINE")) {
                builder.setHealthy(true);
            }
            builder.setStatus((String)v);
        });
        builderInvocations.put("busId", v -> builder.setBusID((String)v));
        builderInvocations.put("major", v -> builder.setMajorNumber(Integer.parseInt(v)));
        builderInvocations.put("minor", v -> builder.setMinorNumber(Integer.parseInt(v)));
        return builderInvocations;
    }

    @VisibleForTesting
    void setCommandExecutorProvider(Function<String[], Shell.CommandExecutor> provider) {
        this.commandExecutorProvider = provider;
    }

    @VisibleForTesting
    void setVeDeviceDiscoverer(VEDeviceDiscoverer veDeviceDiscoverer) {
        this.discoverer = veDeviceDiscoverer;
    }

    @VisibleForTesting
    String getBinaryPath() {
        return this.binaryPath;
    }
}

