/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TimerTask;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeDescriptorsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeDescriptorsScriptRunner<T>
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDescriptorsScriptRunner.class);
    private final Shell.ShellCommandExecutor exec;
    private final NodeDescriptorsProvider provider;

    public NodeDescriptorsScriptRunner(String scriptPath, String[] scriptArgs, long scriptTimeout, NodeDescriptorsProvider ndProvider) {
        ArrayList<String> execScript = new ArrayList<String>();
        execScript.add(scriptPath);
        if (scriptArgs != null) {
            execScript.addAll(Arrays.asList(scriptArgs));
        }
        this.provider = ndProvider;
        this.exec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, scriptTimeout);
    }

    @Override
    public void run() {
        try {
            this.exec.execute();
            this.provider.setDescriptors(this.parseOutput(this.exec.getOutput()));
        }
        catch (Exception e) {
            if (this.exec.isTimedOut()) {
                LOG.warn("Node Labels script timed out, Caught exception : " + e.getMessage(), (Throwable)e);
            }
            LOG.warn("Execution of Node Labels script failed, Caught exception : " + e.getMessage(), (Throwable)e);
        }
    }

    public void cleanUp() {
        Process p;
        if (this.exec != null && (p = this.exec.getProcess()) != null) {
            p.destroy();
        }
    }

    abstract Set<T> parseOutput(String var1) throws IOException;
}

