/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Comparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;

public class PartitionedQueueComparator
implements Comparator<CSQueue> {
    private String partitionToLookAt = null;

    public void setPartitionToLookAt(String partitionToLookAt) {
        this.partitionToLookAt = partitionToLookAt;
    }

    @Override
    public int compare(CSQueue q1, CSQueue q2) {
        float used2;
        boolean q2Accessible;
        boolean q1Accessible = q1.getAccessibleNodeLabels().contains(this.partitionToLookAt) || q1.getAccessibleNodeLabels().contains("*");
        boolean bl = q2Accessible = q2.getAccessibleNodeLabels().contains(this.partitionToLookAt) || q2.getAccessibleNodeLabels().contains("*");
        if (q1Accessible && !q2Accessible) {
            return -1;
        }
        if (!q1Accessible && q2Accessible) {
            return 1;
        }
        float used1 = q1.getQueueCapacities().getUsedCapacity(this.partitionToLookAt);
        if ((double)Math.abs(used1 - (used2 = q2.getQueueCapacities().getUsedCapacity(this.partitionToLookAt))) < 1.0E-6) {
            float cap2;
            float cap1 = q1.getQueueCapacities().getCapacity(this.partitionToLookAt);
            if ((double)Math.abs(cap1 - (cap2 = q2.getQueueCapacities().getCapacity(this.partitionToLookAt))) < 1.0E-6) {
                return q1.getQueueName().compareTo(q2.getQueueName());
            }
            return Float.compare(cap2, cap1);
        }
        return Float.compare(used1, used2);
    }
}

