/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingMonitor
extends AbstractService {
    private final SchedulingEditPolicy scheduleEditPolicy;
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingMonitor.class);
    private ScheduledExecutorService ses;
    private ScheduledFuture<?> handler;
    private volatile boolean stopped;
    private long monitorInterval;
    private RMContext rmContext;

    public SchedulingMonitor(RMContext rmContext, SchedulingEditPolicy scheduleEditPolicy) {
        super("SchedulingMonitor (" + scheduleEditPolicy.getPolicyName() + ")");
        this.scheduleEditPolicy = scheduleEditPolicy;
        this.rmContext = rmContext;
    }

    @VisibleForTesting
    public synchronized SchedulingEditPolicy getSchedulingEditPolicy() {
        return this.scheduleEditPolicy;
    }

    public void serviceInit(Configuration conf) throws Exception {
        LOG.info("Initializing SchedulingMonitor=" + this.getName());
        this.scheduleEditPolicy.init(conf, this.rmContext, this.rmContext.getScheduler());
        this.monitorInterval = this.scheduleEditPolicy.getMonitoringInterval();
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        LOG.info("Starting SchedulingMonitor=" + this.getName());
        assert (!this.stopped) : "starting when already stopped";
        this.ses = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(SchedulingMonitor.this.getName());
                return t;
            }
        });
        this.schedulePreemptionChecker();
        super.serviceStart();
    }

    private void schedulePreemptionChecker() {
        this.handler = this.ses.scheduleAtFixedRate(new PolicyInvoker(), 0L, this.monitorInterval, TimeUnit.MILLISECONDS);
    }

    public void serviceStop() throws Exception {
        this.stopped = true;
        if (this.handler != null) {
            LOG.info("Stop " + this.getName());
            this.handler.cancel(true);
            this.ses.shutdown();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public void invokePolicy() {
        this.scheduleEditPolicy.editSchedule();
    }

    private class PolicyInvoker
    implements Runnable {
        private PolicyInvoker() {
        }

        @Override
        public void run() {
            try {
                if (SchedulingMonitor.this.monitorInterval != SchedulingMonitor.this.scheduleEditPolicy.getMonitoringInterval()) {
                    SchedulingMonitor.this.handler.cancel(true);
                    SchedulingMonitor.this.monitorInterval = SchedulingMonitor.this.scheduleEditPolicy.getMonitoringInterval();
                    SchedulingMonitor.this.schedulePreemptionChecker();
                } else {
                    SchedulingMonitor.this.invokePolicy();
                }
            }
            catch (Throwable t) {
                LOG.error("Exception raised while executing preemption checker, skip this run..., exception=", t);
            }
        }
    }
}

