/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicyFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.CSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStoreFactory;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableCSConfigurationProvider
implements CSConfigurationProvider,
MutableConfigurationProvider {
    public static final Logger LOG = LoggerFactory.getLogger(MutableCSConfigurationProvider.class);
    private Configuration schedConf;
    private Configuration oldConf;
    private YarnConfigurationStore confStore;
    private ConfigurationMutationACLPolicy aclMutationPolicy;
    private RMContext rmContext;
    private final ReentrantReadWriteLock formatLock = new ReentrantReadWriteLock();

    public MutableCSConfigurationProvider(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    @Override
    public void init(Configuration config) throws IOException {
        this.confStore = YarnConfigurationStoreFactory.getStore(config);
        Configuration initialSchedConf = new Configuration(false);
        initialSchedConf.addResource("capacity-scheduler.xml");
        this.schedConf = new Configuration(false);
        for (Map.Entry kv : initialSchedConf) {
            this.schedConf.set((String)kv.getKey(), (String)kv.getValue());
        }
        try {
            this.confStore.initialize(config, this.schedConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.schedConf = this.confStore.retrieve();
        this.aclMutationPolicy = ConfigurationMutationACLPolicyFactory.getPolicy(config);
        this.aclMutationPolicy.init(config, this.rmContext);
    }

    @Override
    public void close() throws IOException {
        this.confStore.close();
    }

    @VisibleForTesting
    public YarnConfigurationStore getConfStore() {
        return this.confStore;
    }

    @Override
    public CapacitySchedulerConfiguration loadConfiguration(Configuration configuration) throws IOException {
        Configuration loadedConf = new Configuration(this.schedConf);
        loadedConf.addResource(configuration);
        return new CapacitySchedulerConfiguration(loadedConf, false);
    }

    @Override
    public Configuration getConfiguration() {
        return new Configuration(this.schedConf);
    }

    @Override
    public long getConfigVersion() throws Exception {
        return this.confStore.getConfigVersion();
    }

    @Override
    public ConfigurationMutationACLPolicy getAclMutationPolicy() {
        return this.aclMutationPolicy;
    }

    @Override
    public YarnConfigurationStore.LogMutation logAndApplyMutation(UserGroupInformation user, SchedConfUpdateInfo confUpdate) throws Exception {
        this.oldConf = new Configuration(this.schedConf);
        CapacitySchedulerConfiguration proposedConf = new CapacitySchedulerConfiguration(this.schedConf, false);
        Map<String, String> kvUpdate = this.constructKeyValueConfUpdate(proposedConf, confUpdate);
        YarnConfigurationStore.LogMutation log = new YarnConfigurationStore.LogMutation(kvUpdate, user.getShortUserName());
        this.confStore.logMutation(log);
        this.applyMutation(proposedConf, kvUpdate);
        this.schedConf = proposedConf;
        return log;
    }

    @Override
    public Configuration applyChanges(Configuration oldConfiguration, SchedConfUpdateInfo confUpdate) throws IOException {
        CapacitySchedulerConfiguration proposedConf = new CapacitySchedulerConfiguration(oldConfiguration, false);
        Map<String, String> kvUpdate = this.constructKeyValueConfUpdate(proposedConf, confUpdate);
        this.applyMutation(proposedConf, kvUpdate);
        return proposedConf;
    }

    private void applyMutation(Configuration conf, Map<String, String> kvUpdate) {
        for (Map.Entry<String, String> kv : kvUpdate.entrySet()) {
            if (kv.getValue() == null) {
                conf.unset(kv.getKey());
                continue;
            }
            conf.set(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void formatConfigurationInStore(Configuration config) throws Exception {
        this.formatLock.writeLock().lock();
        try {
            this.confStore.format();
            this.oldConf = new Configuration(this.schedConf);
            Configuration initialSchedConf = new Configuration(false);
            initialSchedConf.addResource("capacity-scheduler.xml");
            this.schedConf = new Configuration(false);
            for (Map.Entry kv : initialSchedConf) {
                this.schedConf.set((String)kv.getKey(), (String)kv.getValue());
            }
            this.confStore.initialize(config, this.schedConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.formatLock.writeLock().unlock();
        }
    }

    @Override
    public void revertToOldConfig(Configuration config) throws Exception {
        this.formatLock.writeLock().lock();
        try {
            this.schedConf = this.oldConf;
            this.confStore.format();
            this.confStore.initialize(config, this.oldConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.formatLock.writeLock().unlock();
        }
    }

    @Override
    public void confirmPendingMutation(YarnConfigurationStore.LogMutation pendingMutation, boolean isValid) throws Exception {
        this.formatLock.readLock().lock();
        try {
            this.confStore.confirmMutation(pendingMutation, isValid);
            if (!isValid) {
                this.schedConf = this.oldConf;
            }
        }
        finally {
            this.formatLock.readLock().unlock();
        }
    }

    @Override
    public void reloadConfigurationFromStore() throws Exception {
        this.formatLock.readLock().lock();
        try {
            this.schedConf = this.confStore.retrieve();
        }
        finally {
            this.formatLock.readLock().unlock();
        }
    }

    private List<String> getSiblingQueues(String queuePath, Configuration conf) {
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String childQueuesKey = "yarn.scheduler.capacity." + parentQueue + "." + "queues";
        return new ArrayList<String>(conf.getStringCollection(childQueuesKey));
    }

    private Map<String, String> constructKeyValueConfUpdate(CapacitySchedulerConfiguration proposedConf, SchedConfUpdateInfo mutationInfo) throws IOException {
        HashMap<String, String> confUpdate = new HashMap<String, String>();
        for (String string : mutationInfo.getRemoveQueueInfo()) {
            this.removeQueue(string, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getAddQueueInfo()) {
            this.addQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getUpdateQueueInfo()) {
            this.updateQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (Map.Entry entry : mutationInfo.getGlobalParams().entrySet()) {
            confUpdate.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confUpdate;
    }

    private void removeQueue(String queueToRemove, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (queueToRemove == null) {
            return;
        }
        String queueName = queueToRemove.substring(queueToRemove.lastIndexOf(46) + 1);
        if (queueToRemove.lastIndexOf(46) == -1) {
            throw new IOException("Can't remove queue " + queueToRemove);
        }
        List<String> siblingQueues = this.getSiblingQueues(queueToRemove, proposedConf);
        if (!siblingQueues.contains(queueName)) {
            throw new IOException("Queue " + queueToRemove + " not found");
        }
        siblingQueues.remove(queueName);
        String parentQueuePath = queueToRemove.substring(0, queueToRemove.lastIndexOf(46));
        proposedConf.setQueues(parentQueuePath, siblingQueues.toArray(new String[0]));
        String queuesConfig = "yarn.scheduler.capacity." + parentQueuePath + "." + "queues";
        if (siblingQueues.size() == 0) {
            confUpdate.put(queuesConfig, null);
            String queueOrderingPolicy = "yarn.scheduler.capacity." + parentQueuePath + "." + "ordering-policy";
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        } else {
            confUpdate.put(queuesConfig, Joiner.on((char)',').join(siblingQueues));
        }
        for (Map.Entry confRemove : proposedConf.getValByRegex(".*" + queueToRemove.replaceAll("\\.", "\\.") + "\\..*").entrySet()) {
            proposedConf.unset((String)confRemove.getKey());
            confUpdate.put((String)confRemove.getKey(), (String)null);
        }
    }

    private void addQueue(QueueConfigInfo addInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (addInfo == null) {
            return;
        }
        String queuePath = addInfo.getQueue();
        String queueName = queuePath.substring(queuePath.lastIndexOf(46) + 1);
        if (queuePath.lastIndexOf(46) == -1) {
            throw new IOException("Can't add invalid queue " + queuePath);
        }
        if (this.getSiblingQueues(queuePath, proposedConf).contains(queueName)) {
            throw new IOException("Can't add existing queue " + queuePath);
        }
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String[] siblings = proposedConf.getQueues(parentQueue);
        ArrayList<String> siblingQueues = siblings == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(siblings));
        siblingQueues.add(queuePath.substring(queuePath.lastIndexOf(46) + 1));
        proposedConf.setQueues(parentQueue, siblingQueues.toArray(new String[0]));
        confUpdate.put("yarn.scheduler.capacity." + parentQueue + "." + "queues", Joiner.on((char)',').join(siblingQueues));
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : addInfo.getParams().entrySet()) {
            if (kv.getValue() == null) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
            } else {
                proposedConf.set(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
            }
            confUpdate.put(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
        }
        String queueOrderingPolicy = "yarn.scheduler.capacity." + parentQueue + "." + "ordering-policy";
        if (siblingQueues.size() == 1) {
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        }
    }

    private void updateQueue(QueueConfigInfo updateInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) {
        if (updateInfo == null) {
            return;
        }
        String queuePath = updateInfo.getQueue();
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : updateInfo.getParams().entrySet()) {
            String keyValue = (String)kv.getValue();
            if (keyValue == null || keyValue.isEmpty()) {
                keyValue = null;
                proposedConf.unset(keyPrefix + (String)kv.getKey());
            } else {
                proposedConf.set(keyPrefix + (String)kv.getKey(), keyValue);
            }
            confUpdate.put(keyPrefix + (String)kv.getKey(), keyValue);
        }
    }
}

