/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.AbstractComparatorOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.CompoundComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;

public class FairOrderingPolicy<S extends SchedulableEntity>
extends AbstractComparatorOrderingPolicy<S> {
    public static final String ENABLE_SIZE_BASED_WEIGHT = "fair.enable-size-based-weight";
    private CompoundComparator fairComparator;
    private boolean sizeBasedWeight = false;

    public FairOrderingPolicy() {
        ArrayList<Comparator<SchedulableEntity>> comparators = new ArrayList<Comparator<SchedulableEntity>>();
        comparators.add(new FairComparator());
        comparators.add(new FifoComparator());
        this.fairComparator = new CompoundComparator(comparators);
        this.comparator = this.fairComparator;
        this.schedulableEntities = new ConcurrentSkipListSet(this.comparator);
    }

    private double getMagnitude(SchedulableEntity r) {
        double mag = r.getSchedulingResourceUsage().getCachedUsed("*").getMemorySize();
        if (this.sizeBasedWeight) {
            double weight = Math.log1p(r.getSchedulingResourceUsage().getCachedDemand("*").getMemorySize()) / Math.log(2.0);
            mag /= weight;
        }
        return mag;
    }

    @VisibleForTesting
    public boolean getSizeBasedWeight() {
        return this.sizeBasedWeight;
    }

    @VisibleForTesting
    public void setSizeBasedWeight(boolean sizeBasedWeight) {
        this.sizeBasedWeight = sizeBasedWeight;
    }

    @Override
    public void configure(Map<String, String> conf) {
        if (conf.containsKey(ENABLE_SIZE_BASED_WEIGHT)) {
            this.sizeBasedWeight = Boolean.parseBoolean(conf.get(ENABLE_SIZE_BASED_WEIGHT));
        }
    }

    @Override
    public void containerAllocated(S schedulableEntity, RMContainer r) {
        this.entityRequiresReordering(schedulableEntity);
    }

    @Override
    public void containerReleased(S schedulableEntity, RMContainer r) {
        this.entityRequiresReordering(schedulableEntity);
    }

    @Override
    public void demandUpdated(S schedulableEntity) {
        if (this.sizeBasedWeight) {
            this.entityRequiresReordering(schedulableEntity);
        }
    }

    @Override
    public String getInfo() {
        String sbw = this.sizeBasedWeight ? " with sizeBasedWeight" : "";
        return "FairOrderingPolicy" + sbw;
    }

    @Override
    public String getConfigName() {
        return "fair";
    }

    protected class FairComparator
    implements Comparator<SchedulableEntity> {
        protected FairComparator() {
        }

        @Override
        public int compare(SchedulableEntity r1, SchedulableEntity r2) {
            int res = (int)Math.signum(FairOrderingPolicy.this.getMagnitude(r1) - FairOrderingPolicy.this.getMagnitude(r2));
            if (res == 0) {
                res = (int)Math.signum(r1.getStartTime() - r2.getStartTime());
            }
            if (res == 0) {
                res = this.compareDemand(r1, r2);
            }
            return res;
        }

        private int compareDemand(SchedulableEntity s1, SchedulableEntity s2) {
            int res = 0;
            long demand1 = s1.getSchedulingResourceUsage().getCachedDemand("*").getMemorySize();
            long demand2 = s2.getSchedulingResourceUsage().getCachedDemand("*").getMemorySize();
            if (demand1 == 0L && demand2 > 0L) {
                res = 1;
            } else if (demand2 == 0L && demand1 > 0L) {
                res = -1;
            }
            return res;
        }
    }
}

