/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.NodeAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeAllocationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="activities")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActivitiesInfo {
    private String nodeId;
    private Long timestamp;
    private String dateTime;
    private String diagnostic;
    private List<NodeAllocationInfo> allocations;
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiesInfo.class);

    public ActivitiesInfo() {
    }

    public ActivitiesInfo(String errorMessage, String nodeId) {
        this.diagnostic = errorMessage;
        this.nodeId = nodeId;
    }

    public ActivitiesInfo(List<NodeAllocation> nodeAllocations, String nodeId, RMWSConsts.ActivitiesGroupBy groupBy) {
        this.nodeId = nodeId;
        this.allocations = new ArrayList<NodeAllocationInfo>();
        if (nodeAllocations == null) {
            this.diagnostic = nodeId != null ? "waiting for display" : "waiting for next allocation";
        } else if (nodeAllocations.size() == 0) {
            this.diagnostic = "do not have available resources";
        } else {
            NodeId rootNodeId = nodeAllocations.get(0).getNodeId();
            if (rootNodeId != null && !Strings.isNullOrEmpty((String)rootNodeId.getHost())) {
                this.nodeId = nodeAllocations.get(0).getNodeId().toString();
            }
            this.timestamp = nodeAllocations.get(0).getTimestamp();
            Date date = new Date();
            date.setTime(this.timestamp);
            this.dateTime = date.toString();
            for (int i = 0; i < nodeAllocations.size(); ++i) {
                NodeAllocation nodeAllocation = nodeAllocations.get(i);
                NodeAllocationInfo allocationInfo = new NodeAllocationInfo(nodeAllocation, groupBy);
                this.allocations.add(allocationInfo);
            }
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public List<NodeAllocationInfo> getAllocations() {
        return this.allocations;
    }
}

