/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAllocationInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="appActivities")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppActivitiesInfo {
    private String applicationId;
    private String diagnostic;
    private Long timestamp;
    private String dateTime;
    private List<AppAllocationInfo> allocations;
    private static final Logger LOG = LoggerFactory.getLogger(AppActivitiesInfo.class);

    public AppActivitiesInfo() {
    }

    public AppActivitiesInfo(String errorMessage, String applicationId) {
        this.diagnostic = errorMessage;
        this.applicationId = applicationId;
        this.setTime(SystemClock.getInstance().getTime());
    }

    public AppActivitiesInfo(List<AppAllocation> appAllocations, ApplicationId applicationId, RMWSConsts.ActivitiesGroupBy groupBy) {
        this.applicationId = applicationId.toString();
        this.allocations = new ArrayList<AppAllocationInfo>();
        if (appAllocations == null) {
            this.diagnostic = "waiting for display";
            this.setTime(SystemClock.getInstance().getTime());
        } else {
            for (int i = appAllocations.size() - 1; i > -1; --i) {
                AppAllocation appAllocation = appAllocations.get(i);
                AppAllocationInfo appAllocationInfo = new AppAllocationInfo(appAllocation, groupBy);
                this.allocations.add(appAllocationInfo);
            }
        }
    }

    private void setTime(long ts) {
        this.timestamp = ts;
        this.dateTime = new Date(ts).toString();
    }

    @VisibleForTesting
    public List<AppAllocationInfo> getAllocations() {
        return this.allocations;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }
}

