/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RMCriticalThreadUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RMCriticalThreadUncaughtExceptionHandler.class);
    private final RMContext rmContext;

    public RMCriticalThreadUncaughtExceptionHandler(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Throwable ex = e instanceof Exception ? (Exception)e : new YarnException(e);
        RMFatalEvent event = new RMFatalEvent(RMFatalEventType.CRITICAL_THREAD_CRASH, (Exception)ex, String.format("a critical thread, %s, that exited unexpectedly", t.getName()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)event);
    }
}

