/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParser;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineParserForDataToRetrieve
implements TimelineParser {
    private String expr;
    private final int exprLength;

    public TimelineParserForDataToRetrieve(String expression) {
        this.expr = expression;
        if (expression != null) {
            this.expr = this.expr.trim();
            this.exprLength = this.expr.length();
        } else {
            this.exprLength = 0;
        }
    }

    @Override
    public TimelineFilterList parse() throws TimelineParseException {
        String[] splits;
        if (this.expr == null || this.exprLength == 0) {
            return null;
        }
        TimelineCompareOp compareOp = null;
        int openingBracketIndex = this.expr.indexOf(40);
        if (this.expr.charAt(0) == '!') {
            if (openingBracketIndex == -1) {
                throw new TimelineParseException("Invalid config/metric to retrieve expression");
            }
            if (openingBracketIndex != 1 && this.expr.substring(1, openingBracketIndex + 1).trim().length() != 1) {
                throw new TimelineParseException("Invalid config/metric to retrieve expression");
            }
            compareOp = TimelineCompareOp.NOT_EQUAL;
        } else if (openingBracketIndex <= 0) {
            compareOp = TimelineCompareOp.EQUAL;
        }
        char lastChar = this.expr.charAt(this.exprLength - 1);
        if (compareOp == TimelineCompareOp.NOT_EQUAL && lastChar != ')') {
            throw new TimelineParseException("Invalid config/metric to retrieve expression");
        }
        if (openingBracketIndex != -1 && this.expr.charAt(this.exprLength - 1) == ')') {
            this.expr = this.expr.substring(openingBracketIndex + 1, this.exprLength - 1).trim();
        }
        if (this.expr.isEmpty()) {
            return null;
        }
        TimelineFilterList.Operator op = compareOp == TimelineCompareOp.NOT_EQUAL ? TimelineFilterList.Operator.AND : TimelineFilterList.Operator.OR;
        TimelineFilterList list = new TimelineFilterList(op);
        for (String split : splits = this.expr.split(",")) {
            list.addFilter(new TimelinePrefixFilter(compareOp, split.trim()));
        }
        return list;
    }

    @Override
    public void close() {
    }
}

