/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParser;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class TimelineParserForEqualityExpr
implements TimelineParser {
    private final String expr;
    private final String exprInLowerCase;
    private final String exprName;
    private int offset = 0;
    private int startOffset = 0;
    private final int exprLength;
    private ParseState currentParseState = ParseState.PARSING_COMPAREOP;
    private TimelineCompareOp currentCompareOp = null;
    private Deque<TimelineFilterList> filterListStack = new LinkedList<TimelineFilterList>();
    private TimelineFilter currentFilter = null;
    private TimelineFilterList filterList = null;
    private final char delimiter;

    public TimelineParserForEqualityExpr(String expression, String name, char delim) {
        if (expression != null) {
            this.expr = expression.trim();
            this.exprLength = this.expr.length();
            this.exprInLowerCase = this.expr.toLowerCase();
        } else {
            this.exprLength = 0;
            this.expr = null;
            this.exprInLowerCase = null;
        }
        this.exprName = name;
        this.delimiter = delim;
    }

    protected TimelineFilter getCurrentFilter() {
        return this.currentFilter;
    }

    protected TimelineFilter getFilterList() {
        return this.filterList;
    }

    protected abstract TimelineFilter createFilter();

    protected abstract void setCompareOpToCurrentFilter(TimelineCompareOp var1) throws TimelineParseException;

    protected abstract void setValueToCurrentFilter(String var1) throws TimelineParseException;

    private void createAndSetFilter(boolean checkIfNull) throws TimelineParseException {
        if (!checkIfNull || this.currentFilter == null) {
            this.currentFilter = this.createFilter();
            this.setCompareOpToCurrentFilter(this.currentCompareOp);
        }
        this.setValueToCurrentFilter(this.expr.substring(this.startOffset, this.offset).trim());
    }

    private void handleSpaceChar() throws TimelineParseException {
        if (this.currentParseState == ParseState.PARSING_VALUE) {
            if (this.startOffset == this.offset) {
                ++this.startOffset;
            } else {
                this.createAndSetFilter(true);
                this.currentParseState = ParseState.PARSING_OP;
            }
        }
        ++this.offset;
    }

    private void handleDelimiter() throws TimelineParseException {
        if (this.currentParseState == ParseState.PARSING_OP || this.currentParseState == ParseState.PARSING_VALUE) {
            if (this.currentParseState == ParseState.PARSING_VALUE) {
                this.createAndSetFilter(false);
            }
            if (this.filterList == null) {
                this.filterList = new TimelineFilterList();
            }
            this.filterList.addFilter(this.currentFilter);
            this.currentFilter = null;
            ++this.offset;
        } else {
            throw new TimelineParseException("Invalid " + this.exprName + "expression.");
        }
        this.startOffset = this.offset;
        this.currentParseState = ParseState.PARSING_VALUE;
    }

    private void handleOpeningBracketChar(boolean encounteredNot) throws TimelineParseException {
        if (this.currentParseState == ParseState.PARSING_COMPAREOP || this.currentParseState == ParseState.PARSING_VALUE) {
            ++this.offset;
            this.startOffset = this.offset;
            this.filterListStack.push(this.filterList);
            this.filterList = null;
            if (this.currentFilter == null) {
                this.currentFilter = this.createFilter();
            }
        } else {
            throw new TimelineParseException("Encountered unexpected opening bracket while parsing " + this.exprName + ".");
        }
        this.currentCompareOp = encounteredNot ? TimelineCompareOp.NOT_EQUAL : TimelineCompareOp.EQUAL;
        this.setCompareOpToCurrentFilter(this.currentCompareOp);
        this.currentParseState = ParseState.PARSING_VALUE;
    }

    private void handleNotChar() throws TimelineParseException {
        if (this.currentParseState == ParseState.PARSING_COMPAREOP || this.currentParseState == ParseState.PARSING_VALUE) {
            ++this.offset;
            while (this.offset < this.exprLength && this.expr.charAt(this.offset) == ' ') {
                ++this.offset;
            }
            if (this.offset == this.exprLength) {
                throw new TimelineParseException("Invalid " + this.exprName + "expression");
            }
            if (this.expr.charAt(this.offset) != '(') {
                throw new TimelineParseException("Invalid " + this.exprName + "expression");
            }
        } else {
            throw new TimelineParseException("Encountered unexpected not(!) char while parsing " + this.exprName + ".");
        }
        this.handleOpeningBracketChar(true);
    }

    private void handleClosingBracketChar() throws TimelineParseException {
        if (this.currentParseState != ParseState.PARSING_VALUE && this.currentParseState != ParseState.PARSING_OP) {
            throw new TimelineParseException("Encountered unexpected closing bracket while parsing " + this.exprName + ".");
        }
        if (!this.filterListStack.isEmpty()) {
            TimelineFilterList fList;
            if (this.currentParseState == ParseState.PARSING_VALUE && this.startOffset != this.offset) {
                this.createAndSetFilter(true);
                this.currentParseState = ParseState.PARSING_OP;
            }
            if (this.filterList == null) {
                this.filterList = new TimelineFilterList();
            }
            if (this.currentFilter != null) {
                this.filterList.addFilter(this.currentFilter);
            }
            if ((fList = this.filterListStack.pop()) != null) {
                fList.addFilter(this.filterList);
                this.filterList = fList;
            }
            this.currentFilter = null;
            ++this.offset;
        } else {
            throw new TimelineParseException("Encountered unexpected closing bracket while parsing " + this.exprName + ".");
        }
        this.startOffset = this.offset;
    }

    private void parseOp(boolean closingBracket) throws TimelineParseException {
        TimelineFilterList.Operator operator = null;
        if (this.exprInLowerCase.startsWith("or ", this.offset)) {
            operator = TimelineFilterList.Operator.OR;
            this.offset += 3;
        } else if (this.exprInLowerCase.startsWith("and ", this.offset)) {
            operator = TimelineFilterList.Operator.AND;
            this.offset += 4;
        }
        if (operator == null) {
            throw new TimelineParseException("Operator cannot be parsed for " + this.exprName + ".");
        }
        if (this.filterList == null) {
            this.filterList = new TimelineFilterList(operator);
        }
        if (this.currentFilter != null) {
            this.filterList.addFilter(this.currentFilter);
        }
        if (closingBracket || this.filterList.getOperator() != operator) {
            this.filterList = new TimelineFilterList(operator, this.filterList);
        }
        this.currentFilter = null;
        this.startOffset = this.offset;
        this.currentParseState = ParseState.PARSING_COMPAREOP;
    }

    private void parseCompareOp() throws TimelineParseException {
        if (this.currentFilter == null) {
            this.currentFilter = this.createFilter();
        }
        this.currentCompareOp = TimelineCompareOp.EQUAL;
        this.setCompareOpToCurrentFilter(this.currentCompareOp);
        this.currentParseState = ParseState.PARSING_VALUE;
    }

    @Override
    public TimelineFilterList parse() throws TimelineParseException {
        if (this.expr == null || this.exprLength == 0) {
            return null;
        }
        boolean closingBracket = false;
        block6: while (this.offset < this.exprLength) {
            char offsetChar = this.expr.charAt(this.offset);
            switch (offsetChar) {
                case '!': {
                    this.handleNotChar();
                    continue block6;
                }
                case ' ': {
                    this.handleSpaceChar();
                    continue block6;
                }
                case '(': {
                    this.handleOpeningBracketChar(false);
                    continue block6;
                }
                case ')': {
                    this.handleClosingBracketChar();
                    closingBracket = true;
                    continue block6;
                }
            }
            if (offsetChar == this.delimiter) {
                this.handleDelimiter();
                continue;
            }
            if (this.currentParseState == ParseState.PARSING_COMPAREOP) {
                this.parseCompareOp();
                continue;
            }
            if (this.currentParseState == ParseState.PARSING_OP) {
                this.parseOp(closingBracket);
                closingBracket = false;
                continue;
            }
            ++this.offset;
        }
        if (!this.filterListStack.isEmpty()) {
            this.filterListStack.clear();
            throw new TimelineParseException("Encountered improper brackets while parsing " + this.exprName + ".");
        }
        if (this.currentParseState == ParseState.PARSING_VALUE && this.startOffset != this.offset) {
            this.createAndSetFilter(true);
        }
        if (this.filterList == null || this.filterList.getFilterList().isEmpty()) {
            this.filterList = new TimelineFilterList(this.currentFilter);
        } else if (this.currentFilter != null) {
            this.filterList.addFilter(this.currentFilter);
        }
        return this.filterList;
    }

    @Override
    public void close() {
        if (this.filterListStack != null) {
            this.filterListStack.clear();
        }
        this.currentFilter = null;
        this.filterList = null;
    }

    private static enum ParseState {
        PARSING_VALUE,
        PARSING_OP,
        PARSING_COMPAREOP;

    }
}

