/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUtils;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.TrackingUriPlugin;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WebAppProxyServlet.class);
    private static final String REDIRECT = "/redirect";
    private static final Set<String> PASS_THROUGH_HEADERS = new HashSet<String>(Arrays.asList("User-Agent", "Accept", "Accept-Encoding", "Accept-Language", "Accept-Charset", "Content-Type"));
    public static final String PROXY_USER_COOKIE_NAME = "proxy-user";
    private transient List<TrackingUriPlugin> trackingUriPlugins;
    private final String rmAppPageUrlBase;
    private final String ahsAppPageUrlBase;
    private final String failurePageUrlBase;
    private transient YarnConfiguration conf = new YarnConfiguration();

    public WebAppProxyServlet() {
        this.trackingUriPlugins = this.conf.getInstances("yarn.tracking.url.generator", TrackingUriPlugin.class);
        this.rmAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf), "cluster", "app"});
        this.failurePageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf), "cluster", "failure"});
        this.ahsAppPageUrlBase = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)this.conf), "applicationhistory", "app"});
    }

    private static void notFound(HttpServletResponse resp, String message) throws IOException {
        ProxyUtils.notFound(resp, message);
    }

    private static void warnUserPage(HttpServletResponse resp, String link, String user, ApplicationId id) throws IOException {
        resp.addCookie(WebAppProxyServlet.makeCheckCookie(id, false));
        resp.setContentType("text/html; charset=UTF-8");
        Page p = new Page(resp.getWriter());
        ((Hamlet.HTML)p.html().h1("WARNING: The following page may not be safe!").h3()._(new Object[]{"click "}).a(link, "here")._(new Object[]{" to continue to an Application Master web interface owned by ", user})._())._();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void proxyLink(HttpServletRequest req, HttpServletResponse resp, URI link, Cookie c, String proxyHost, HTTP method) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility").setBooleanParameter("http.protocol.allow-circular-redirects", true);
        InetAddress localAddress = InetAddress.getByName(proxyHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("local InetAddress for proxy host: {}", (Object)localAddress);
        }
        client.getParams().setParameter("http.route.local-address", (Object)localAddress);
        HttpGet base = null;
        if (method.equals((Object)HTTP.GET)) {
            base = new HttpGet(link);
        } else if (method.equals((Object)HTTP.PUT)) {
            String line;
            base = new HttpPut(link);
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            ((HttpPut)base).setEntity((HttpEntity)new StringEntity(sb.toString()));
        } else {
            resp.setStatus(405);
            return;
        }
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!PASS_THROUGH_HEADERS.contains(name)) continue;
            String value = req.getHeader(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug("REQ HEADER: {} : {}", (Object)name, (Object)value);
            }
            base.setHeader(name, value);
        }
        String user = req.getRemoteUser();
        if (user != null && !user.isEmpty()) {
            base.setHeader("Cookie", "proxy-user=" + URLEncoder.encode(user, "ASCII"));
        }
        ServletOutputStream out = resp.getOutputStream();
        try {
            InputStream in;
            CloseableHttpResponse httpResp = client.execute((HttpUriRequest)base);
            resp.setStatus(httpResp.getStatusLine().getStatusCode());
            for (Header header : httpResp.getAllHeaders()) {
                resp.setHeader(header.getName(), header.getValue());
            }
            if (c != null) {
                resp.addCookie(c);
            }
            if ((in = httpResp.getEntity().getContent()) != null) {
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096, (boolean)true);
            }
        }
        finally {
            base.releaseConnection();
        }
    }

    private static String getCheckCookieName(ApplicationId id) {
        return "checked_" + id;
    }

    private static Cookie makeCheckCookie(ApplicationId id, boolean isSet) {
        Cookie c = new Cookie(WebAppProxyServlet.getCheckCookieName(id), String.valueOf(isSet));
        c.setPath(ProxyUriUtils.getPath(id));
        c.setMaxAge(7200);
        return c;
    }

    private boolean isSecurityEnabled() {
        Boolean b = (Boolean)this.getServletContext().getAttribute("IsSecurityEnabled");
        return b != null ? b : false;
    }

    private AppReportFetcher.FetchedAppReport getApplicationReport(ApplicationId id) throws IOException, YarnException {
        return ((AppReportFetcher)this.getServletContext().getAttribute("AppUrlFetcher")).getApplicationReport(id);
    }

    private String getProxyHost() throws IOException {
        return (String)this.getServletContext().getAttribute("proxyHost");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.methodAction(req, resp, HTTP.GET);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.methodAction(req, resp, HTTP.PUT);
    }

    private void methodAction(HttpServletRequest req, HttpServletResponse resp, HTTP method) throws ServletException, IOException {
        try {
            AppReportFetcher.FetchedAppReport fetchedAppReport;
            String userApprovedParamS = req.getParameter("proxyapproved");
            boolean userWasWarned = false;
            boolean userApproved = Boolean.valueOf(userApprovedParamS);
            boolean securityEnabled = this.isSecurityEnabled();
            boolean isRedirect = false;
            String pathInfo = req.getPathInfo();
            String remoteUser = req.getRemoteUser();
            String[] parts = null;
            if (pathInfo != null) {
                if (pathInfo.startsWith(REDIRECT)) {
                    pathInfo = pathInfo.substring(REDIRECT.length());
                    isRedirect = true;
                }
                parts = pathInfo.split("/", 3);
            }
            if (parts == null || parts.length < 2) {
                LOG.warn("{} gave an invalid proxy path {}", (Object)remoteUser, (Object)pathInfo);
                WebAppProxyServlet.notFound(resp, "Your path appears to be formatted incorrectly.");
                return;
            }
            String appId = parts[1];
            String rest = parts.length > 2 ? parts[2] : "";
            ApplicationId id = Apps.toAppID((String)appId);
            if (id == null) {
                LOG.warn("{} attempting to access {} that is invalid", (Object)remoteUser, (Object)appId);
                WebAppProxyServlet.notFound(resp, appId + " appears to be formatted incorrectly.");
                return;
            }
            if (isRedirect && this.handleRedirect(appId, req, resp)) {
                return;
            }
            if (securityEnabled) {
                String cookieName = WebAppProxyServlet.getCheckCookieName(id);
                Cookie[] cookies = req.getCookies();
                if (cookies != null) {
                    for (Cookie c : cookies) {
                        if (!cookieName.equals(c.getName())) continue;
                        userWasWarned = true;
                        userApproved = userApproved || Boolean.valueOf(c.getValue()) != false;
                        break;
                    }
                }
            }
            boolean checkUser = securityEnabled && (!userWasWarned || !userApproved);
            try {
                fetchedAppReport = this.getFetchedAppReport(id);
            }
            catch (ApplicationNotFoundException e) {
                fetchedAppReport = null;
            }
            ApplicationReport applicationReport = null;
            if (fetchedAppReport != null) {
                applicationReport = fetchedAppReport.getApplicationReport();
            }
            if (applicationReport == null) {
                LOG.warn("{} attempting to access {} that was not found", (Object)remoteUser, (Object)id);
                URI toFetch = ProxyUriUtils.getUriFromTrackingPlugins(id, this.trackingUriPlugins);
                if (toFetch != null) {
                    ProxyUtils.sendRedirect(req, resp, toFetch.toString());
                    return;
                }
                WebAppProxyServlet.notFound(resp, "Application " + appId + " could not be found " + "in RM or history server");
                return;
            }
            URI trackingUri = this.getTrackingUri(req, resp, id, applicationReport.getOriginalTrackingUrl(), fetchedAppReport.getAppReportSource());
            if (trackingUri == null) {
                return;
            }
            String runningUser = applicationReport.getUser();
            if (checkUser && !runningUser.equals(remoteUser)) {
                LOG.info("Asking {} if they want to connect to the app master GUI of {} owned by {}", new Object[]{remoteUser, appId, runningUser});
                WebAppProxyServlet.warnUserPage(resp, ProxyUriUtils.getPathAndQuery(id, rest, req.getQueryString(), true), runningUser, id);
                return;
            }
            URI toFetch = this.buildTrackingUrl(trackingUri, req, rest);
            LOG.info("{} is accessing unchecked {} which is the app master GUI of {} owned by {}", new Object[]{remoteUser, toFetch, appId, runningUser});
            switch (applicationReport.getYarnApplicationState()) {
                case KILLED: 
                case FINISHED: 
                case FAILED: {
                    ProxyUtils.sendRedirect(req, resp, toFetch.toString());
                    return;
                }
            }
            Cookie c = null;
            if (userWasWarned && userApproved) {
                c = WebAppProxyServlet.makeCheckCookie(id, true);
            }
            WebAppProxyServlet.proxyLink(req, resp, toFetch, c, this.getProxyHost(), method);
        }
        catch (URISyntaxException | YarnException e) {
            throw new IOException(e);
        }
    }

    private URI buildTrackingUrl(URI trackingUri, HttpServletRequest req, String rest) throws UriBuilderException {
        UriBuilder builder = UriBuilder.fromUri((URI)trackingUri);
        String queryString = req.getQueryString();
        if (queryString != null) {
            List queryPairs = URLEncodedUtils.parse((String)queryString, null);
            for (NameValuePair pair : queryPairs) {
                builder.queryParam(pair.getName(), new Object[]{pair.getValue()});
            }
        }
        return builder.path(rest).build(new Object[0]);
    }

    private URI getTrackingUri(HttpServletRequest req, HttpServletResponse resp, ApplicationId id, String originalUri, AppReportFetcher.AppReportSource appReportSource) throws IOException, URISyntaxException {
        URI trackingUri = null;
        if (originalUri == null || originalUri.equals("N/A") || originalUri.equals("")) {
            if (appReportSource == AppReportFetcher.AppReportSource.RM) {
                LOG.debug("Original tracking url is '{}'. Redirecting to RM app page", (Object)(originalUri == null ? "NULL" : originalUri));
                ProxyUtils.sendRedirect(req, resp, StringHelper.pjoin((Object[])new Object[]{this.rmAppPageUrlBase, id.toString()}));
            } else if (appReportSource == AppReportFetcher.AppReportSource.AHS) {
                LOG.debug("Original tracking url is '{}'. Redirecting to AHS app page", (Object)(originalUri == null ? "NULL" : originalUri));
                ProxyUtils.sendRedirect(req, resp, StringHelper.pjoin((Object[])new Object[]{this.ahsAppPageUrlBase, id.toString()}));
            }
        } else {
            trackingUri = ProxyUriUtils.getSchemeFromUrl(originalUri).isEmpty() ? ProxyUriUtils.getUriFromAMUrl(WebAppUtils.getHttpSchemePrefix((Configuration)this.conf), originalUri) : new URI(originalUri);
        }
        return trackingUri;
    }

    private AppReportFetcher.FetchedAppReport getFetchedAppReport(ApplicationId id) throws IOException, YarnException {
        AppReportFetcher.FetchedAppReport fetchedAppReport = this.getApplicationReport(id);
        if (fetchedAppReport != null && fetchedAppReport.getAppReportSource() != AppReportFetcher.AppReportSource.RM && fetchedAppReport.getAppReportSource() != AppReportFetcher.AppReportSource.AHS) {
            throw new UnsupportedOperationException("Application report not fetched from RM or history server.");
        }
        return fetchedAppReport;
    }

    private boolean handleRedirect(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean badRedirect = false;
        try {
            badRedirect = NetUtils.getLocalInetAddress((String)req.getRemoteHost()) != null;
        }
        catch (SocketException ex) {
            // empty catch block
        }
        if (badRedirect) {
            LOG.error("The AM's web app redirected the RM web proxy's request back to the web proxy. The typical cause is that the AM is resolving the RM's address as something other than what it expects. Check your network configuration and the value of the yarn.web-proxy.address property. Once the host resolution issue has been resolved, you will likely need to delete the misbehaving application, " + id);
            String redirect = StringHelper.pjoin((Object[])new Object[]{this.failurePageUrlBase, id});
            LOG.error("REDIRECT: sending redirect to " + redirect);
            ProxyUtils.sendRedirect(req, resp, redirect);
        }
        return badRedirect;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.conf = new YarnConfiguration();
        this.trackingUriPlugins = this.conf.getInstances("yarn.tracking.url.generator", TrackingUriPlugin.class);
    }

    private static class Page
    extends Hamlet {
        Page(PrintWriter out) {
            super(out, 0, false);
        }

        public Hamlet.HTML<_> html() {
            return new Hamlet.HTML((Hamlet)this, "html", null, EnumSet.of(HamletImpl.EOpt.ENDTAG));
        }
    }

    private static class _
    implements HamletSpec._ {
        private _() {
        }
    }

    private static enum HTTP {
        GET,
        POST,
        HEAD,
        PUT,
        DELETE;

    }
}

