/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hama.graph.Edge;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.Vertex;

public final class GraphJobMessage
implements Writable {
    public static final int MAP_FLAG = 1;
    public static final int VERTEX_FLAG = 2;
    public static final int REPAIR_FLAG = 4;
    public static final int PARTITION_FLAG = 8;
    public static Class<?> VERTEX_CLASS;
    public static Class<? extends Writable> VERTEX_ID_CLASS;
    public static Class<? extends Writable> VERTEX_VALUE_CLASS;
    public static Class<? extends Writable> EDGE_VALUE_CLASS;
    private int flag = 1;
    private MapWritable map;
    private Writable vertexId;
    private Writable vertexValue;
    private Vertex<?, ?, ?> vertex;

    public GraphJobMessage() {
    }

    public GraphJobMessage(MapWritable map) {
        this.flag = 1;
        this.map = map;
    }

    public GraphJobMessage(Writable vertexId) {
        this.flag = 4;
        this.vertexId = vertexId;
    }

    public GraphJobMessage(Writable vertexId, Writable vertexValue) {
        this.flag = 2;
        this.vertexId = vertexId;
        this.vertexValue = vertexValue;
    }

    public GraphJobMessage(Vertex<?, ?, ?> vertex) {
        this.flag = 8;
        this.vertex = vertex;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.flag);
        if (this.isVertexMessage()) {
            this.vertexId.write(out);
            this.vertexValue.write(out);
        } else if (this.isMapMessage()) {
            this.map.write(out);
        } else if (this.isPartitioningMessage()) {
            this.vertex.getVertexID().write(out);
            if (this.vertex.getValue() != null) {
                out.writeBoolean(true);
                this.vertex.getValue().write(out);
            } else {
                out.writeBoolean(false);
            }
            List<Edge<?, ?>> outEdges = this.vertex.getEdges();
            out.writeInt(outEdges.size());
            Iterator<Edge<?, ?>> i$ = outEdges.iterator();
            while (i$.hasNext()) {
                Edge<?, ?> e;
                Edge<?, ?> edge = e = i$.next();
                out.writeUTF(edge.getDestinationPeerName());
                edge.getDestinationVertexID().write(out);
                if (edge.getValue() != null) {
                    out.writeBoolean(true);
                    edge.getValue().write(out);
                    continue;
                }
                out.writeBoolean(false);
            }
        } else {
            this.vertexId.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.flag = in.readByte();
        if (this.isVertexMessage()) {
            this.vertexId = (Writable)ReflectionUtils.newInstance(VERTEX_ID_CLASS, null);
            this.vertexId.readFields(in);
            this.vertexValue = (Writable)ReflectionUtils.newInstance(VERTEX_VALUE_CLASS, null);
            this.vertexValue.readFields(in);
        } else if (this.isMapMessage()) {
            this.map = new MapWritable();
            this.map.readFields(in);
        } else if (this.isPartitioningMessage()) {
            Vertex vertex = GraphJobRunner.newVertexInstance(VERTEX_CLASS, null);
            Writable vertexId = (Writable)ReflectionUtils.newInstance(VERTEX_ID_CLASS, null);
            vertexId.readFields(in);
            vertex.setVertexID(vertexId);
            if (in.readBoolean()) {
                Writable vertexValue = (Writable)ReflectionUtils.newInstance(VERTEX_VALUE_CLASS, null);
                vertexValue.readFields(in);
                vertex.setValue(vertexValue);
            }
            int size = in.readInt();
            vertex.setEdges(new ArrayList(size));
            for (int i = 0; i < size; ++i) {
                String destination = in.readUTF();
                Writable edgeVertexID = (Writable)ReflectionUtils.newInstance(VERTEX_ID_CLASS, null);
                edgeVertexID.readFields(in);
                Writable edgeValue = null;
                if (in.readBoolean()) {
                    edgeValue = (Writable)ReflectionUtils.newInstance(EDGE_VALUE_CLASS, null);
                    edgeValue.readFields(in);
                }
                vertex.getEdges().add(new Edge<Writable, Writable>(edgeVertexID, destination, edgeValue));
            }
            this.vertex = vertex;
        } else {
            this.vertexId = (Writable)ReflectionUtils.newInstance(VERTEX_ID_CLASS, null);
            this.vertexId.readFields(in);
        }
    }

    public MapWritable getMap() {
        return this.map;
    }

    public Writable getVertexId() {
        return this.vertexId;
    }

    public Writable getVertexValue() {
        return this.vertexValue;
    }

    public Vertex<?, ?, ?> getVertex() {
        return this.vertex;
    }

    public boolean isMapMessage() {
        return this.flag == 1;
    }

    public boolean isVertexMessage() {
        return this.flag == 2;
    }

    public boolean isRepairMessage() {
        return this.flag == 4;
    }

    public boolean isPartitioningMessage() {
        return this.flag == 8;
    }

    public String toString() {
        return "GraphJobMessage [flag=" + this.flag + ", map=" + this.map + ", vertexId=" + this.vertexId + ", vertexValue=" + this.vertexValue + ", vertex=" + this.vertex + "]";
    }
}

