/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hama.bsp.BSPPeer;
import org.apache.hama.bsp.Partitioner;
import org.apache.hama.graph.Edge;
import org.apache.hama.graph.GraphJobMessage;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.VertexInterface;

public abstract class Vertex<V extends Writable, E extends Writable, M extends Writable>
implements VertexInterface<V, E, M> {
    GraphJobRunner<?, ?, ?> runner;
    private V vertexID;
    private M value;
    private List<Edge<V, E>> edges;
    private boolean votedToHalt = false;

    public Configuration getConf() {
        return this.runner.getPeer().getConfiguration();
    }

    @Override
    public V getVertexID() {
        return this.vertexID;
    }

    @Override
    public void setup(Configuration conf) {
    }

    @Override
    public void sendMessage(Edge<V, E> e, M msg) throws IOException {
        this.runner.getPeer().send(this.getDestinationPeerName((V)e), (Writable)new GraphJobMessage((Writable)e.getDestinationVertexID(), (Writable)msg));
    }

    public String getDestinationPeerName(Edge<V, E> edge) {
        return this.getDestinationPeerName(edge.getDestinationVertexID());
    }

    public String getDestinationPeerName(V vertexId) {
        return this.runner.getPeer().getPeerName(this.getPartitioner().getPartition(vertexId, this.value, this.runner.getPeer().getNumPeers()));
    }

    @Override
    public void sendMessageToNeighbors(M msg) throws IOException {
        List<Edge<V, E>> outEdges = this.getEdges();
        for (Edge<V, E> e : outEdges) {
            this.sendMessage((V)e, msg);
        }
    }

    @Override
    public void sendMessage(V destinationVertexID, M msg) throws IOException {
        int partition = this.getPartitioner().getPartition(destinationVertexID, msg, this.runner.getPeer().getNumPeers());
        String destPeer = this.runner.getPeer().getAllPeerNames()[partition];
        this.runner.getPeer().send(destPeer, (Writable)new GraphJobMessage((Writable)destinationVertexID, (Writable)msg));
    }

    @Override
    public long getSuperstepCount() {
        return this.runner.getNumberIterations();
    }

    public void setEdges(List<Edge<V, E>> list) {
        this.edges = list;
    }

    public void addEdge(Edge<V, E> edge) {
        if (this.edges == null) {
            this.edges = new ArrayList<Edge<V, E>>(1);
        }
        this.edges.add(edge);
    }

    @Override
    public List<Edge<V, E>> getEdges() {
        return this.edges;
    }

    @Override
    public M getValue() {
        return this.value;
    }

    @Override
    public void setValue(M value) {
        this.value = value;
    }

    public void setVertexID(V vertexID) {
        this.vertexID = vertexID;
    }

    public int getMaxIteration() {
        return this.runner.getMaxIteration();
    }

    public M getLastAggregatedValue(int index) {
        return (M)this.runner.getLastAggregatedValue(index);
    }

    public IntWritable getNumLastAggregatedVertices(int index) {
        return this.runner.getNumLastAggregatedVertices(index);
    }

    public int getNumPeers() {
        return this.runner.getPeer().getNumPeers();
    }

    public BSPPeer<Writable, Writable, Writable, Writable, GraphJobMessage> getPeer() {
        return this.runner.getPeer();
    }

    public Partitioner<V, M> getPartitioner() {
        return this.runner.getPartitioner();
    }

    @Override
    public long getNumVertices() {
        return this.runner.getNumberVertices();
    }

    @Override
    public void voteToHalt() {
        this.votedToHalt = true;
    }

    void setActive() {
        this.votedToHalt = false;
    }

    public boolean isHalted() {
        return this.votedToHalt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vertexID == null ? 0 : this.vertexID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return !(this.vertexID == null ? other.vertexID != null : !this.vertexID.equals(other.vertexID));
    }

    public String toString() {
        return this.getVertexID() + (this.getValue() != null ? " = " + this.getValue() : "") + " // " + this.edges;
    }
}

