/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.HamaConfiguration;
import org.apache.hama.bsp.TaskAttemptID;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.IDSkippingIterator;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VerticesInfo;

public final class ListVerticesInfo<V extends WritableComparable<V>, E extends Writable, M extends Writable>
implements VerticesInfo<V, E, M> {
    private GraphJobRunner<V, E, M> runner;
    Vertex<V, E, M> v;
    private final List<byte[]> verticesList = new ArrayList<byte[]>();
    private boolean lockedAdditions = false;
    private int index = 0;
    private ByteArrayOutputStream bos = null;
    private DataOutputStream dos = null;
    private ByteArrayInputStream bis = null;
    private DataInputStream dis = null;

    @Override
    public void init(GraphJobRunner<V, E, M> runner, HamaConfiguration conf, TaskAttemptID attempt) throws IOException {
        this.runner = runner;
    }

    @Override
    public void addVertex(Vertex<V, E, M> vertex) throws IOException {
        Preconditions.checkArgument((!this.lockedAdditions ? 1 : 0) != 0, (Object)"Additions are locked now, nobody is allowed to change the structure anymore.");
        this.verticesList.add(this.serialize(vertex));
    }

    @Override
    public void removeVertex(V vertexID) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ListVerticesInfo doesn't support this operation. Please use the MapVerticesInfo.");
    }

    public void clear() {
        this.verticesList.clear();
    }

    @Override
    public int size() {
        return this.verticesList.size();
    }

    @Override
    public IDSkippingIterator<V, E, M> skippingIterator() {
        return new IDSkippingIterator<V, E, M>(){
            Iterator<byte[]> it;
            {
                this.it = ListVerticesInfo.this.verticesList.iterator();
            }

            @Override
            public boolean hasNext(V msgId, IDSkippingIterator.Strategy strat) throws IOException {
                if (this.it.hasNext()) {
                    byte[] serialized = this.it.next();
                    ListVerticesInfo.this.v = ListVerticesInfo.this.deserialize(serialized);
                    while (!strat.accept(ListVerticesInfo.this.v, (WritableComparable)msgId)) {
                        if (this.it.hasNext()) {
                            serialized = this.it.next();
                            ListVerticesInfo.this.v = ListVerticesInfo.this.deserialize(serialized);
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                ListVerticesInfo.this.v = null;
                return false;
            }

            @Override
            public Vertex<V, E, M> next() {
                if (ListVerticesInfo.this.v == null) {
                    throw new UnsupportedOperationException("You must invoke hasNext before ask for the next vertex.");
                }
                Vertex tmp = ListVerticesInfo.this.v;
                ListVerticesInfo.this.v = null;
                return tmp;
            }
        };
    }

    public byte[] serialize(Vertex<V, E, M> vertex) throws IOException {
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
        vertex.write(this.dos);
        return this.bos.toByteArray();
    }

    public Vertex<V, E, M> deserialize(byte[] serialized) throws IOException {
        this.bis = new ByteArrayInputStream(serialized);
        this.dis = new DataInputStream(this.bis);
        this.v = GraphJobRunner.newVertexInstance(GraphJobRunner.VERTEX_CLASS);
        this.v.readFields(this.dis);
        this.v.setRunner(this.runner);
        return this.v;
    }

    @Override
    public void finishVertexComputation(Vertex<V, E, M> vertex) throws IOException {
        this.verticesList.set(this.index, this.serialize(vertex));
        ++this.index;
    }

    @Override
    public void finishAdditions() {
        this.lockedAdditions = true;
    }

    @Override
    public void finishRemovals() {
        throw new UnsupportedOperationException("ListVerticesInfo doesn't support this operation. Please use the MapVerticesInfo.");
    }

    @Override
    public void finishSuperstep() {
    }

    @Override
    public void cleanup(HamaConfiguration conf, TaskAttemptID attempt) throws IOException {
    }

    @Override
    public void startSuperstep() throws IOException {
        this.index = 0;
    }
}

