/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hama.graph;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hama.HamaConfiguration;
import org.apache.hama.bsp.TaskAttemptID;
import org.apache.hama.graph.GraphJobRunner;
import org.apache.hama.graph.IDSkippingIterator;
import org.apache.hama.graph.Vertex;
import org.apache.hama.graph.VerticesInfo;

public final class MapVerticesInfo<V extends WritableComparable<V>, E extends Writable, M extends Writable>
implements VerticesInfo<V, E, M> {
    private GraphJobRunner<V, E, M> runner;
    Vertex<V, E, M> v;
    private final SortedMap<V, byte[]> verticesMap = new TreeMap<V, byte[]>();
    private ByteArrayOutputStream bos = null;
    private DataOutputStream dos = null;
    private ByteArrayInputStream bis = null;
    private DataInputStream dis = null;

    @Override
    public void init(GraphJobRunner<V, E, M> runner, HamaConfiguration conf, TaskAttemptID attempt) throws IOException {
        this.runner = runner;
    }

    @Override
    public void addVertex(Vertex<V, E, M> vertex) throws IOException {
        if (this.verticesMap.containsKey(vertex.getVertexID())) {
            throw new UnsupportedOperationException("Vertex with ID: " + vertex.getVertexID() + " already exists!");
        }
        this.verticesMap.put((byte[])vertex.getVertexID(), this.serialize(vertex));
    }

    @Override
    public void removeVertex(V vertexID) throws UnsupportedOperationException {
        if (!this.verticesMap.containsKey(vertexID)) {
            throw new UnsupportedOperationException("Vertex with ID: " + vertexID + " not found on this peer.");
        }
        this.verticesMap.remove(vertexID);
    }

    public void clear() {
        this.verticesMap.clear();
    }

    @Override
    public int size() {
        return this.verticesMap.size();
    }

    @Override
    public IDSkippingIterator<V, E, M> skippingIterator() {
        return new IDSkippingIterator<V, E, M>(){
            Iterator<V> it;
            {
                this.it = MapVerticesInfo.this.verticesMap.keySet().iterator();
            }

            @Override
            public boolean hasNext(V msgId, IDSkippingIterator.Strategy strat) throws IOException {
                if (this.it.hasNext()) {
                    WritableComparable vertexID = (WritableComparable)this.it.next();
                    MapVerticesInfo.this.v = MapVerticesInfo.this.deserialize(vertexID, (byte[])MapVerticesInfo.this.verticesMap.get(vertexID));
                    while (!strat.accept(MapVerticesInfo.this.v, (WritableComparable)msgId)) {
                        if (this.it.hasNext()) {
                            vertexID = (WritableComparable)this.it.next();
                            MapVerticesInfo.this.v = MapVerticesInfo.this.deserialize(vertexID, (byte[])MapVerticesInfo.this.verticesMap.get(vertexID));
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                MapVerticesInfo.this.v = null;
                return false;
            }

            @Override
            public Vertex<V, E, M> next() {
                if (MapVerticesInfo.this.v == null) {
                    throw new UnsupportedOperationException("You must invoke hasNext before ask for the next vertex.");
                }
                Vertex tmp = MapVerticesInfo.this.v;
                MapVerticesInfo.this.v = null;
                return tmp;
            }
        };
    }

    public byte[] serialize(Vertex<V, E, M> vertex) throws IOException {
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
        vertex.write(this.dos);
        return this.bos.toByteArray();
    }

    public Vertex<V, E, M> deserialize(V vertexID, byte[] serialized) throws IOException {
        this.bis = new ByteArrayInputStream(serialized);
        this.dis = new DataInputStream(this.bis);
        this.v = GraphJobRunner.newVertexInstance(GraphJobRunner.VERTEX_CLASS);
        this.v.readFields(this.dis);
        this.v.setRunner(this.runner);
        this.v.setVertexID(vertexID);
        return this.v;
    }

    @Override
    public void finishVertexComputation(Vertex<V, E, M> vertex) throws IOException {
        this.verticesMap.put((byte[])vertex.getVertexID(), this.serialize(vertex));
    }

    @Override
    public void finishAdditions() {
    }

    @Override
    public void finishRemovals() {
    }

    @Override
    public void finishSuperstep() {
    }

    @Override
    public void cleanup(HamaConfiguration conf, TaskAttemptID attempt) throws IOException {
    }

    @Override
    public void startSuperstep() throws IOException {
    }
}

