/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.security.access.AccessControlConstants;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Query
extends OperationWithAttributes {
    protected Filter filter = null;

    public Filter getFilter() {
        return this.filter;
    }

    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public void setAuthorizations(Authorizations authorizations) {
        this.setAttribute("VISIBILITY", ProtobufUtil.toAuthorizations(authorizations).toByteArray());
    }

    public Authorizations getAuthorizations() throws DeserializationException {
        byte[] authorizationsBytes = this.getAttribute("VISIBILITY");
        if (authorizationsBytes == null) {
            return null;
        }
        return ProtobufUtil.toAuthorizations(authorizationsBytes);
    }

    public byte[] getACL() {
        return this.getAttribute("acl");
    }

    public void setACL(String user, Permission perms) {
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions(user, perms).toByteArray());
    }

    public void setACL(Map<String, Permission> perms) {
        ArrayListMultimap permMap = ArrayListMultimap.create();
        for (Map.Entry<String, Permission> entry : perms.entrySet()) {
            permMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.setAttribute("acl", ProtobufUtil.toUsersAndPermissions((ListMultimap<String, Permission>)permMap).toByteArray());
    }

    public boolean getACLStrategy() {
        byte[] bytes = this.getAttribute("acl.strategy");
        if (bytes != null) {
            return Bytes.equals((byte[])bytes, (byte[])AccessControlConstants.OP_ATTRIBUTE_ACL_STRATEGY_CELL_FIRST);
        }
        return false;
    }

    public void setACLStrategy(boolean cellFirstStrategy) {
        if (cellFirstStrategy) {
            this.setAttribute("acl.strategy", AccessControlConstants.OP_ATTRIBUTE_ACL_STRATEGY_CELL_FIRST);
        }
    }
}

