/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessControlProtos.GrantResponse grant(Configuration conf, final TableName tableName, final String userName, final byte[] family, final byte[] qual, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.GrantResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.GrantResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.GrantRequest.Builder builder = AccessControlProtos.GrantRequest.newBuilder();
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    if (family != null) {
                        permissionBuilder.setFamily(HBaseZeroCopyByteString.wrap((byte[])family));
                    }
                    if (qual != null) {
                        permissionBuilder.setQualifier(HBaseZeroCopyByteString.wrap((byte[])qual));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    builder.setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)userName)).setPermission(ret));
                    service.grant((RpcController)this.controller, builder.build(), this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.GrantResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.GrantResponse grantResponse = result.values().iterator().next();
            return grantResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessControlProtos.RevokeResponse revoke(Configuration conf, final String username, final TableName tableName, final byte[] family, final byte[] qualifier, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        HTable ht = null;
        try {
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.RevokeResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.RevokeResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    if (tableName != null) {
                        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    }
                    if (family != null) {
                        permissionBuilder.setFamily(HBaseZeroCopyByteString.wrap((byte[])family));
                    }
                    if (qualifier != null) {
                        permissionBuilder.setQualifier(HBaseZeroCopyByteString.wrap((byte[])qualifier));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    AccessControlProtos.RevokeRequest builder = AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
                    service.revoke((RpcController)this.controller, builder, this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.RevokeResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.RevokeResponse revokeResponse = result.values().iterator().next();
            return revokeResponse;
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
    }
}

