/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ScanMetrics {
    private static final Log LOG = LogFactory.getLog(ScanMetrics.class);
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    public final AtomicLong countOfRPCcalls = this.createCounter("RPC_CALLS");
    public final AtomicLong countOfRemoteRPCcalls = this.createCounter("REMOTE_RPC_CALLS");
    public final AtomicLong sumOfMillisSecBetweenNexts = this.createCounter("MILLIS_BETWEEN_NEXTS");
    public final AtomicLong countOfNSRE = this.createCounter("NOT_SERVING_REGION_EXCEPTION");
    public final AtomicLong countOfBytesInResults = this.createCounter("BYTES_IN_RESULTS");
    public final AtomicLong countOfBytesInRemoteResults = this.createCounter("BYTES_IN_REMOTE_RESULTS");
    public final AtomicLong countOfRegions = this.createCounter("REGIONS_SCANNED");
    public final AtomicLong countOfRPCRetries = this.createCounter("RPC_RETRIES");
    public final AtomicLong countOfRemoteRPCRetries = this.createCounter("REMOTE_RPC_RETRIES");

    private AtomicLong createCounter(String counterName) {
        AtomicLong c = new AtomicLong(0L);
        this.counters.put(counterName, c);
        return c;
    }

    public void setCounter(String counterName, long value) {
        AtomicLong c = this.counters.get(counterName);
        if (c != null) {
            c.set(value);
        }
    }

    public Map<String, Long> getMetricsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, AtomicLong> e : this.counters.entrySet()) {
            builder.put((Object)e.getKey(), (Object)e.getValue().getAndSet(0L));
        }
        return builder.build();
    }
}

