/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.security.User;

public abstract class AbstractHBaseAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);

    public void setUser(User user) {
        LOG.debug((Object)"setUser() called with MapR Table without impersonation support.");
    }

    public abstract boolean tableExists(String var1) throws IOException;

    public abstract HTableDescriptor[] listTables() throws IOException;

    public abstract TableName[] listTableNames() throws IOException;

    public abstract HTableDescriptor[] listTables(String var1) throws IOException;

    public String[] getTableNames() throws IOException {
        return this.getTableNames((String)null);
    }

    public String[] getTableNames(Pattern pattern) throws IOException {
        return this.getTableNames(pattern.pattern());
    }

    public String[] getTableNames(String regex) throws IOException {
        ArrayList<String> tables = new ArrayList<String>();
        for (HTableDescriptor desc : this.listTables(regex)) {
            tables.add(desc.getNameAsString());
        }
        return tables.toArray(new String[tables.size()]);
    }

    public abstract HTableDescriptor getTableDescriptor(String var1) throws TableNotFoundException, IOException;

    public abstract void createTable(HTableDescriptor var1, byte[][] var2) throws IOException;

    public abstract void deleteTable(String var1) throws IOException;

    public abstract HTableDescriptor[] deleteTables(String var1) throws IOException;

    public abstract void enableTable(String var1) throws IOException;

    public abstract HTableDescriptor[] enableTables(String var1) throws IOException;

    public abstract void disableTable(String var1) throws IOException;

    public abstract HTableDescriptor[] disableTables(String var1) throws IOException;

    public abstract boolean isTableEnabled(String var1) throws IOException;

    public abstract boolean isTableDisabled(String var1) throws IOException;

    public abstract boolean isTableAvailable(String var1) throws IOException;

    public abstract boolean isTableAvailable(String var1, byte[][] var2) throws IOException;

    public abstract void addColumn(String var1, HColumnDescriptor var2) throws IOException;

    public abstract void deleteColumn(String var1, String var2) throws IOException;

    public abstract void modifyColumn(String var1, HColumnDescriptor var2) throws IOException;

    public abstract void modifyTable(String var1, HTableDescriptor var2) throws IOException;

    public abstract List<HRegionInfo> getTableRegions(byte[] var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        LOG.warn((Object)"closeRegion() called for a MapR Table, silently ignoring.");
    }

    public void closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        LOG.warn((Object)"closeRegionWithEncodedRegionName() called for a MapR Table, silently ignoring.");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        LOG.warn((Object)"closeRegion() called for a MapR Table, silently ignoring.");
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException {
        LOG.warn((Object)"flush() called for a MapR Table, silently ignoring.");
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily, boolean major) throws IOException {
        LOG.warn((Object)"compact() called for a MapR Table, silently ignoring.");
    }

    public void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        LOG.warn((Object)"compact() called for a MapR Table, silently ignoring.");
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
        LOG.warn((Object)"move() called for a MapR Table, silently ignoring.");
    }

    public void offline(byte[] regionName) throws ZooKeeperConnectionException {
        LOG.warn((Object)"offline() called for a MapR Table, silently ignoring.");
    }

    public boolean enableCatalogJanitor(boolean enable) throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"enableCatalogJanitor for MapR, silently ignoring.");
        return false;
    }

    public int runCatalogScan() throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"runCatalogScan for MapR, silently ignoring.");
        return 0;
    }

    public boolean isCatalogJanitorEnabled() throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"isCatalogJanitorEnabled for MapR, silently ignoring.");
        return false;
    }

    public void assign(byte[] regionName) throws IOException {
        LOG.warn((Object)"assign() called for a MapR Table, silently ignoring.");
    }

    public void unassign(byte[] regionName, boolean force) throws IOException {
        LOG.warn((Object)"unassign() called for a MapR Table, silently ignoring.");
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        LOG.warn((Object)"split() called for a MapR Table, silently ignoring.");
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = null;
        if (preserveSplits) {
            List<HRegionInfo> regions = this.getTableRegions(tableName.getQualifier());
            Collections.sort(regions);
            ArrayList<byte[]> splitKeyList = new ArrayList<byte[]>(regions.size());
            for (HRegionInfo region : regions) {
                if (region.getEndKey() == null || region.getEndKey().length == 0) continue;
                splitKeyList.add(region.getEndKey());
            }
            splitKeys = (byte[][])splitKeyList.toArray((T[])new byte[splitKeyList.size()][]);
        }
        String tablePath = tableName.getAliasAsString();
        HTableDescriptor htd = this.getTableDescriptor(tablePath);
        this.deleteTable(tablePath);
        htd.remove(HTableDescriptor.MAPR_UUID_KEY);
        htd.remove("DISABLED");
        this.createTable(htd, splitKeys);
    }
}

