/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.common.base.Stopwatch;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MetaRegionTracker
extends ZooKeeperNodeTracker {
    public MetaRegionTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.metaServerZNode, abortable);
    }

    public boolean isLocationAvailable() {
        return this.getMetaRegionLocation() != null;
    }

    public ServerName getMetaRegionLocation() {
        RegionState regionState = this.getMetaRegionState();
        return regionState.isOpened() ? regionState.getServerName() : null;
    }

    public static ServerName getMetaRegionLocation(ZooKeeperWatcher zkw) throws KeeperException {
        byte[] data = ZKUtil.getData(zkw, zkw.metaServerZNode);
        RegionState regionState = MetaRegionTracker.getMetaRegionState(data);
        return regionState.isOpened() ? regionState.getServerName() : null;
    }

    public ServerName waitMetaRegionLocation(long timeout) throws InterruptedException {
        if (!this.checkIfBaseNodeAvailable()) {
            String errorMsg = "Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
            LOG.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        return this.blockUntilAvailable(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerName blockUntilAvailable(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout shouldn't be less than zero");
        }
        Stopwatch sw = new Stopwatch().start();
        ServerName sn = null;
        try {
            while ((sn = this.getMetaRegionLocation()) == null) {
                if (sw.elapsedMillis() > timeout - 200L) {
                    break;
                }
                Thread.sleep(200L);
            }
        }
        finally {
            sw.stop();
        }
        return sn;
    }

    public static void setMetaLocation(ZooKeeperWatcher zookeeper, ServerName location, RegionState.State regionState) throws KeeperException {
        LOG.info((Object)("Setting hbase:meta region location in ZooKeeper as " + location));
        byte[] data = MetaRegionTracker.toByteArray(location, regionState);
        try {
            ZKUtil.createAndWatch(zookeeper, zookeeper.metaServerZNode, data);
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.debug((Object)"META region location already existed, updated location");
            ZKUtil.setData(zookeeper, zookeeper.metaServerZNode, data);
        }
    }

    static byte[] toByteArray(ServerName sn, RegionState.State regionState) {
        HBaseProtos.ServerName pbsn = HBaseProtos.ServerName.newBuilder().setHostName(sn.getHostname()).setPort(sn.getPort()).setStartCode(sn.getStartcode()).build();
        ZooKeeperProtos.MetaRegionServer pbrsr = ZooKeeperProtos.MetaRegionServer.newBuilder().setServer(pbsn).setRpcVersion(0).setState(regionState.convert()).build();
        return ProtobufUtil.prependPBMagic(pbrsr.toByteArray());
    }

    public static void deleteMetaLocation(ZooKeeperWatcher zookeeper) throws KeeperException {
        LOG.info((Object)"Unsetting hbase:meta region location in ZooKeeper");
        try {
            ZKUtil.deleteNode(zookeeper, zookeeper.metaServerZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public static ServerName blockUntilAvailable(ZooKeeperWatcher zkw, long timeout) throws InterruptedException {
        byte[] data = ZKUtil.blockUntilAvailable(zkw, zkw.metaServerZNode, timeout);
        RegionState regionState = MetaRegionTracker.getMetaRegionState(data);
        return regionState.isOpened() ? regionState.getServerName() : null;
    }

    private static RegionState getMetaRegionState(byte[] data) {
        ServerName serverName;
        RegionState.State state;
        block7: {
            state = RegionState.State.OPEN;
            serverName = null;
            try {
                if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix(data)) {
                    try {
                        int prefixLen = ProtobufUtil.lengthOfPBMagic();
                        ZooKeeperProtos.MetaRegionServer rl = (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                        if (rl.hasState()) {
                            state = RegionState.State.convert(rl.getState());
                        }
                        HBaseProtos.ServerName sn = rl.getServer();
                        serverName = ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
                        break block7;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new DeserializationException("Unable to parse root region location");
                    }
                }
                serverName = ServerName.parseFrom(data);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)"Failed parse", (Throwable)e);
                return null;
            }
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(HRegionInfo.FIRST_META_REGIONINFO, state, serverName);
    }

    public RegionState getMetaRegionState() {
        byte[] data = super.getData(true);
        return MetaRegionTracker.getMetaRegionState(data);
    }
}

