/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientSmallReversedScanner
extends ReversedClientScanner {
    private static final Log LOG = LogFactory.getLog(ClientSmallReversedScanner.class);
    private ScannerCallableWithReplicas smallReversedScanCallable = null;
    private SmallReversedScannerCallableFactory callableFactory;

    public ClientSmallReversedScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        this(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout, new SmallReversedScannerCallableFactory());
    }

    @VisibleForTesting
    ClientSmallReversedScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, SmallReversedScannerCallableFactory callableFactory) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
        this.callableFactory = callableFactory;
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        boolean regionChanged = true;
        boolean isFirstRegionToLocate = false;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] startKey = this.currentRegion.getStartKey();
            if (startKey == null || Bytes.equals((byte[])startKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(startKey) || done) {
                this.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                return false;
            }
            localStartKey = ClientSmallReversedScanner.createClosestRowBefore(startKey);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            regionChanged = false;
            localStartKey = ClientSmallReversedScanner.createClosestRowBefore(this.lastResult.getRow());
        } else {
            localStartKey = this.scan.getStartRow();
            isFirstRegionToLocate = true;
        }
        if (!isFirstRegionToLocate && (localStartKey == null || Bytes.equals((byte[])localStartKey, (byte[])HConstants.EMPTY_BYTE_ARRAY))) {
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallReversedScanCallable = this.callableFactory.getCallable(this.getConnection(), this.getTable(), this.scan, this.getScanMetrics(), localStartKey, cacheNum, this.rpcControllerFactory, this.getPool(), this.getPrimaryOperationTimeout(), this.getRetries(), this.getScannerTimeout(), this.getConf(), this.caller, isFirstRegionToLocate);
        if (this.scanMetrics != null && regionChanged) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    protected void loadCache() throws IOException {
        Result[] values = null;
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        boolean currentRegionDone = false;
        while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
            values = this.caller.callWithoutRetries(this.smallReversedScanCallable, this.scannerTimeout);
            this.currentRegion = this.smallReversedScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    this.cache.add(rs);
                    for (Cell cell : rs.rawCells()) {
                        remainingResultSize -= CellUtil.estimatedHeapSizeOf((Cell)cell);
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            }
            if (this.smallReversedScanCallable.hasMoreResultsContext()) {
                currentRegionDone = !this.smallReversedScanCallable.getServerHasMoreResults();
                continue;
            }
            currentRegionDone = countdown > 0;
        }
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    @VisibleForTesting
    protected void setScannerCallableFactory(SmallReversedScannerCallableFactory callableFactory) {
        this.callableFactory = callableFactory;
    }

    protected static class SmallReversedScannerCallableFactory {
        protected SmallReversedScannerCallableFactory() {
        }

        public ScannerCallableWithReplicas getCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, byte[] localStartKey, int cacheNum, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, int retries, int scannerTimeout, Configuration conf, RpcRetryingCaller<Result[]> caller, boolean isFirstRegionToLocate) {
            byte[] locateStartRow = null;
            if (isFirstRegionToLocate && (localStartKey == null || Bytes.equals((byte[])localStartKey, (byte[])HConstants.EMPTY_BYTE_ARRAY))) {
                locateStartRow = ClientScanner.MAX_BYTE_ARRAY;
            }
            scan.setStartRow(localStartKey);
            SmallReversedScannerCallable s = new SmallReversedScannerCallable(connection, table, scan, scanMetrics, locateStartRow, controllerFactory, cacheNum, 0);
            ScannerCallableWithReplicas scannerCallableWithReplicas = new ScannerCallableWithReplicas(table, connection, s, pool, primaryOperationTimeout, scan, retries, scannerTimeout, cacheNum, conf, caller);
            return scannerCallableWithReplicas;
        }
    }

    static class SmallReversedScannerCallable
    extends ReversedScannerCallable {
        public SmallReversedScannerCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, byte[] locateStartRow, RpcControllerFactory controllerFactory, int caching, int replicaId) {
            super(connection, table, scan, scanMetrics, locateStartRow, controllerFactory, replicaId);
            this.setCaching(caching);
        }

        @Override
        public Result[] call(int timeout) throws IOException {
            if (this.closed) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.getScan(), this.getCaching(), true);
            ClientProtos.ScanResponse response = null;
            this.controller = this.controllerFactory.newController();
            try {
                this.controller.setPriority(this.getTableName());
                this.controller.setCallTimeout(timeout);
                response = this.getStub().scan((RpcController)this.controller, request);
                Result[] results = ResponseConverter.getResults(this.controller.cellScanner(), response);
                if (response.hasMoreResultsInRegion()) {
                    this.setHasMoreResultsContext(true);
                    this.setServerHasMoreResults(response.getMoreResultsInRegion());
                } else {
                    this.setHasMoreResultsContext(false);
                }
                this.updateResultsMetrics(results);
                return results;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }

        @Override
        public ScannerCallable getScannerCallableForReplica(int id) {
            return new SmallReversedScannerCallable(this.getConnection(), this.getTableName(), this.getScan(), this.scanMetrics, this.locateStartRow, this.controllerFactory, this.getCaching(), id);
        }
    }
}

