/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.IndividualBytesFieldCell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.RawCell;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.io.ByteArrayDataInput;
import org.apache.hbase.thirdparty.com.google.common.io.ByteArrayDataOutput;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class Mutation
extends OperationWithAttributes
implements Row,
CellScannable,
HeapSize {
    public static final long MUTATION_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + ClassSize.REFERENCE + ClassSize.REFERENCE + ClassSize.TREEMAP + ClassSize.INTEGER));
    private static final String CONSUMED_CLUSTER_IDS = "_cs.id";
    private static final String OP_ATTRIBUTE_TTL = "_ttl";
    private static final String RETURN_RESULTS = "_rr_";
    protected byte[] row = null;
    protected long ts = Long.MAX_VALUE;
    protected Durability durability = Durability.USE_DEFAULT;
    protected NavigableMap<byte[], List<Cell>> familyMap;

    protected Mutation() {
        this.familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
    }

    protected Mutation(Mutation clone) {
        super(clone);
        this.row = clone.getRow();
        this.ts = clone.getTimestamp();
        this.familyMap = clone.getFamilyCellMap().entrySet().stream().collect(Collectors.toMap(e -> (byte[])e.getKey(), e -> new ArrayList((Collection)e.getValue()), (k, v) -> {
            throw new RuntimeException("collisions!!!");
        }, () -> new TreeMap(Bytes.BYTES_COMPARATOR)));
    }

    protected Mutation(byte[] row, long ts, NavigableMap<byte[], List<Cell>> familyMap) {
        this.row = (byte[])Preconditions.checkNotNull((Object)row);
        if (row.length == 0) {
            throw new IllegalArgumentException("Row can't be empty");
        }
        this.ts = ts;
        this.familyMap = (NavigableMap)Preconditions.checkNotNull(familyMap);
    }

    public CellScanner cellScanner() {
        return CellUtil.createCellScanner(this.getFamilyCellMap());
    }

    List<Cell> getCellList(byte[] family) {
        ArrayList list = (ArrayList)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList();
            this.familyMap.put(family, list);
        }
        return list;
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value, Tag[] tags) {
        KeyValue kvWithTag = new KeyValue(this.row, family, qualifier, ts, value, tags);
        return kvWithTag;
    }

    KeyValue createPutKeyValue(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value, Tag[] tags) {
        return new KeyValue(this.row, 0, this.row == null ? 0 : this.row.length, family, 0, family == null ? 0 : family.length, qualifier, ts, KeyValue.Type.Put, value, tags != null ? Arrays.asList(tags) : null);
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>(this.familyMap.entrySet().size());
        map.put("families", families);
        for (Map.Entry entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])((byte[])entry.getKey())));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary((byte[])this.row));
        int colCount = 0;
        for (Map.Entry entry : this.familyMap.entrySet()) {
            ArrayList<Map<String, Object>> qualifierDetails = new ArrayList<Map<String, Object>>();
            columns.put(Bytes.toStringBinary((byte[])((byte[])entry.getKey())), qualifierDetails);
            colCount += ((List)entry.getValue()).size();
            if (maxCols <= 0) continue;
            for (Cell cell : (List)entry.getValue()) {
                if (--maxCols <= 0) continue;
                Map<String, Object> cellMap = Mutation.cellToStringMap(cell);
                qualifierDetails.add(cellMap);
            }
        }
        map.put("totalColumns", colCount);
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        if (this.getTTL() != Long.MAX_VALUE) {
            map.put("ttl", this.getTTL());
        }
        map.put("ts", this.ts);
        return map;
    }

    private static Map<String, Object> cellToStringMap(Cell c) {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("qualifier", Bytes.toStringBinary((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength()));
        stringMap.put("timestamp", c.getTimestamp());
        stringMap.put("vlen", c.getValueLength());
        List tags = PrivateCellUtil.getTags((Cell)c);
        if (tags != null) {
            ArrayList<String> tagsString = new ArrayList<String>(tags.size());
            for (Tag t : tags) {
                tagsString.add(t.getType() + ":" + Bytes.toStringBinary((byte[])Tag.cloneValue((Tag)t)));
            }
            stringMap.put("tag", tagsString);
        }
        return stringMap;
    }

    public Mutation setDurability(Durability d) {
        this.durability = d;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public NavigableMap<byte[], List<Cell>> getFamilyCellMap() {
        return this.familyMap;
    }

    @Deprecated
    public Mutation setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        this.familyMap = map;
        return this;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    @Override
    @Deprecated
    public int compareTo(Row d) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])d.getRow());
    }

    @Deprecated
    public long getTimeStamp() {
        return this.getTimestamp();
    }

    public long getTimestamp() {
        return this.ts;
    }

    public Mutation setClusterIds(List<UUID> clusterIds) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeInt(clusterIds.size());
        for (UUID clusterId : clusterIds) {
            out.writeLong(clusterId.getMostSignificantBits());
            out.writeLong(clusterId.getLeastSignificantBits());
        }
        this.setAttribute(CONSUMED_CLUSTER_IDS, out.toByteArray());
        return this;
    }

    public List<UUID> getClusterIds() {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        byte[] bytes = this.getAttribute(CONSUMED_CLUSTER_IDS);
        if (bytes != null) {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
            int numClusters = in.readInt();
            for (int i = 0; i < numClusters; ++i) {
                clusterIds.add(new UUID(in.readLong(), in.readLong()));
            }
        }
        return clusterIds;
    }

    public Mutation setCellVisibility(CellVisibility expression) {
        this.setAttribute("VISIBILITY", Mutation.toCellVisibility(expression).toByteArray());
        return this;
    }

    public CellVisibility getCellVisibility() throws DeserializationException {
        byte[] cellVisibilityBytes = this.getAttribute("VISIBILITY");
        if (cellVisibilityBytes == null) {
            return null;
        }
        return Mutation.toCellVisibility(cellVisibilityBytes);
    }

    static ClientProtos.CellVisibility toCellVisibility(CellVisibility cellVisibility) {
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        builder.setExpression(cellVisibility.getExpression());
        return builder.build();
    }

    private static CellVisibility toCellVisibility(ClientProtos.CellVisibility proto) {
        if (proto == null) {
            return null;
        }
        return new CellVisibility(proto.getExpression());
    }

    private static CellVisibility toCellVisibility(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        ClientProtos.CellVisibility proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return Mutation.toCellVisibility(proto);
    }

    public int size() {
        int size = 0;
        for (List cells : this.familyMap.values()) {
            size += cells.size();
        }
        return size;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public long heapSize() {
        long heapsize = MUTATION_OVERHEAD;
        heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + this.row.length));
        heapsize += (long)ClassSize.align((int)(this.familyMap.size() * ClassSize.MAP_ENTRY));
        for (Map.Entry entry : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + ((byte[])entry.getKey()).length));
            heapsize += (long)ClassSize.align((int)ClassSize.ARRAYLIST);
            int size = ((List)entry.getValue()).size();
            heapsize += (long)ClassSize.align((int)(ClassSize.ARRAY + size * ClassSize.REFERENCE));
            for (Cell cell : (List)entry.getValue()) {
                heapsize += cell.heapSize();
            }
        }
        heapsize += this.getAttributeSize();
        return ClassSize.align((long)(heapsize += this.extraHeapSize()));
    }

    public byte[] getACL() {
        return this.getAttribute("acl");
    }

    public Mutation setACL(String user, Permission perms) {
        this.setAttribute("acl", AccessControlUtil.toUsersAndPermissions(user, perms).toByteArray());
        return this;
    }

    public Mutation setACL(Map<String, Permission> perms) {
        ArrayListMultimap permMap = ArrayListMultimap.create();
        for (Map.Entry<String, Permission> entry : perms.entrySet()) {
            permMap.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.setAttribute("acl", AccessControlUtil.toUsersAndPermissions((ListMultimap<String, Permission>)permMap).toByteArray());
        return this;
    }

    public long getTTL() {
        byte[] ttlBytes = this.getAttribute(OP_ATTRIBUTE_TTL);
        if (ttlBytes != null) {
            return Bytes.toLong((byte[])ttlBytes);
        }
        return Long.MAX_VALUE;
    }

    public Mutation setTTL(long ttl) {
        this.setAttribute(OP_ATTRIBUTE_TTL, Bytes.toBytes((long)ttl));
        return this;
    }

    @InterfaceAudience.Private
    protected boolean isReturnResults() {
        byte[] v = this.getAttribute(RETURN_RESULTS);
        return v == null ? true : Bytes.toBoolean((byte[])v);
    }

    @InterfaceAudience.Private
    protected Mutation setReturnResults(boolean returnResults) {
        this.setAttribute(RETURN_RESULTS, Bytes.toBytes((boolean)returnResults));
        return this;
    }

    protected long extraHeapSize() {
        return 0L;
    }

    public Mutation setTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        this.ts = timestamp;
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, HConstants.EMPTY_BYTE_ARRAY, true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, HConstants.EMPTY_BYTE_ARRAY, false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    public List<Cell> get(byte[] family, byte[] qualifier) {
        ArrayList<Cell> filteredList = new ArrayList<Cell>();
        for (Cell cell : this.getCellList(family)) {
            if (!CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
            filteredList.add(cell);
        }
        return filteredList;
    }

    protected boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<Cell> list = this.getCellList(family);
        if (list.isEmpty()) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value)) continue;
                return true;
            }
        } else {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    static byte[] checkRow(byte[] row) {
        return Mutation.checkRow(row, 0, row == null ? 0 : row.length);
    }

    static byte[] checkRow(byte[] row, int offset, int length) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (length == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + length + " is > " + Short.MAX_VALUE);
        }
        return row;
    }

    static void checkRow(ByteBuffer row) {
        if (row == null) {
            throw new IllegalArgumentException("Row buffer is null");
        }
        if (row.remaining() == 0) {
            throw new IllegalArgumentException("Row length is 0");
        }
        if (row.remaining() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row length " + row.remaining() + " is > " + Short.MAX_VALUE);
        }
    }

    Mutation add(Cell cell) throws IOException {
        if (!CellUtil.matchingRows((Cell)cell, (byte[])this.row)) {
            throw new WrongRowIOException("The row in " + cell.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        byte[] family = cell instanceof IndividualBytesFieldCell ? cell.getFamilyArray() : CellUtil.cloneFamily((Cell)cell);
        if (family == null || family.length == 0) {
            throw new IllegalArgumentException("Family cannot be null");
        }
        if (cell instanceof ExtendedCell) {
            this.getCellList(family).add(cell);
        } else {
            this.getCellList(family).add((Cell)new CellWrapper(cell));
        }
        return this;
    }

    private static final class CellWrapper
    implements ExtendedCell {
        private static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 8 + 8 + 1 * ClassSize.REFERENCE));
        private final Cell cell;
        private long sequenceId;
        private long timestamp;

        CellWrapper(Cell cell) {
            assert (!(cell instanceof ExtendedCell));
            this.cell = cell;
            this.sequenceId = cell.getSequenceId();
            this.timestamp = cell.getTimestamp();
        }

        public void setSequenceId(long seqId) {
            this.sequenceId = seqId;
        }

        public void setTimestamp(long ts) {
            this.timestamp = ts;
        }

        public void setTimestamp(byte[] ts) {
            this.timestamp = Bytes.toLong((byte[])ts);
        }

        public long getSequenceId() {
            return this.sequenceId;
        }

        public byte[] getValueArray() {
            return this.cell.getValueArray();
        }

        public int getValueOffset() {
            return this.cell.getValueOffset();
        }

        public int getValueLength() {
            return this.cell.getValueLength();
        }

        public byte[] getTagsArray() {
            return this.cell.getTagsArray();
        }

        public int getTagsOffset() {
            return this.cell.getTagsOffset();
        }

        public int getTagsLength() {
            return this.cell.getTagsLength();
        }

        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        public short getRowLength() {
            return this.cell.getRowLength();
        }

        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        public Optional<Tag> getTag(byte type) {
            if (this.cell instanceof RawCell) {
                return ((RawCell)this.cell).getTag(type);
            }
            return PrivateCellUtil.getTag((Cell)this.cell, (byte)type);
        }

        public Iterator<Tag> getTags() {
            if (this.cell instanceof RawCell) {
                return ((RawCell)this.cell).getTags();
            }
            return PrivateCellUtil.tagsIterator((Cell)this.cell);
        }

        public byte[] cloneTags() {
            if (this.cell instanceof RawCell) {
                return ((RawCell)this.cell).cloneTags();
            }
            return PrivateCellUtil.cloneTags((Cell)this.cell);
        }

        private long heapOverhead() {
            return FIXED_OVERHEAD + (long)ClassSize.ARRAY + (long)this.getFamilyLength() == 0L ? 0L : (ClassSize.ARRAY + this.getQualifierLength() == 0 ? 0L : (ClassSize.ARRAY + this.getValueLength() == 0 ? 0L : (ClassSize.ARRAY + this.getTagsLength() == 0 ? 0L : (long)ClassSize.ARRAY)));
        }

        public long heapSize() {
            return this.heapOverhead() + (long)ClassSize.align((int)this.getRowLength()) + (long)ClassSize.align((int)this.getFamilyLength()) + (long)ClassSize.align((int)this.getQualifierLength()) + (long)ClassSize.align((int)this.getValueLength()) + (long)ClassSize.align((int)this.getTagsLength());
        }
    }
}

