/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableDescriptorBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(TableDescriptorBuilder.class);
    @InterfaceAudience.Private
    public static final String SPLIT_POLICY = "SPLIT_POLICY";
    private static final Bytes SPLIT_POLICY_KEY = new Bytes(Bytes.toBytes((String)"SPLIT_POLICY"));
    @InterfaceAudience.Private
    public static final String MAX_FILESIZE = "MAX_FILESIZE";
    private static final Bytes MAX_FILESIZE_KEY = new Bytes(Bytes.toBytes((String)"MAX_FILESIZE"));
    @InterfaceAudience.Private
    public static final String OWNER = "OWNER";
    @InterfaceAudience.Private
    public static final Bytes OWNER_KEY = new Bytes(Bytes.toBytes((String)"OWNER"));
    @InterfaceAudience.Private
    public static final String READONLY = "READONLY";
    private static final Bytes READONLY_KEY = new Bytes(Bytes.toBytes((String)"READONLY"));
    @InterfaceAudience.Private
    public static final String COMPACTION_ENABLED = "COMPACTION_ENABLED";
    private static final Bytes COMPACTION_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"COMPACTION_ENABLED"));
    @InterfaceAudience.Private
    public static final String SPLIT_ENABLED = "SPLIT_ENABLED";
    private static final Bytes SPLIT_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"SPLIT_ENABLED"));
    @InterfaceAudience.Private
    public static final String MERGE_ENABLED = "MERGE_ENABLED";
    private static final Bytes MERGE_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"MERGE_ENABLED"));
    @InterfaceAudience.Private
    public static final String MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    private static final Bytes MEMSTORE_FLUSHSIZE_KEY = new Bytes(Bytes.toBytes((String)"MEMSTORE_FLUSHSIZE"));
    @InterfaceAudience.Private
    public static final String FLUSH_POLICY = "FLUSH_POLICY";
    private static final Bytes FLUSH_POLICY_KEY = new Bytes(Bytes.toBytes((String)"FLUSH_POLICY"));
    @InterfaceAudience.Private
    public static final String IS_META = "IS_META";
    private static final Bytes IS_META_KEY = new Bytes(Bytes.toBytes((String)"IS_META"));
    @InterfaceAudience.Private
    public static final String DURABILITY = "DURABILITY";
    private static final Bytes DURABILITY_KEY = new Bytes(Bytes.toBytes((String)"DURABILITY"));
    @InterfaceAudience.Private
    public static final String REGION_REPLICATION = "REGION_REPLICATION";
    private static final Bytes REGION_REPLICATION_KEY = new Bytes(Bytes.toBytes((String)"REGION_REPLICATION"));
    @InterfaceAudience.Private
    public static final String REGION_MEMSTORE_REPLICATION = "REGION_MEMSTORE_REPLICATION";
    private static final Bytes REGION_MEMSTORE_REPLICATION_KEY = new Bytes(Bytes.toBytes((String)"REGION_MEMSTORE_REPLICATION"));
    private static final Bytes REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH_CONF_KEY = new Bytes(Bytes.toBytes((String)"hbase.region.replica.wait.for.primary.flush"));
    @InterfaceAudience.Private
    public static final String NORMALIZATION_ENABLED = "NORMALIZATION_ENABLED";
    private static final Bytes NORMALIZATION_ENABLED_KEY = new Bytes(Bytes.toBytes((String)"NORMALIZATION_ENABLED"));
    @InterfaceAudience.Private
    public static final String NORMALIZER_TARGET_REGION_COUNT = "NORMALIZER_TARGET_REGION_COUNT";
    private static final Bytes NORMALIZER_TARGET_REGION_COUNT_KEY = new Bytes(Bytes.toBytes((String)"NORMALIZER_TARGET_REGION_COUNT"));
    @InterfaceAudience.Private
    public static final String NORMALIZER_TARGET_REGION_SIZE = "NORMALIZER_TARGET_REGION_SIZE";
    private static final Bytes NORMALIZER_TARGET_REGION_SIZE_KEY = new Bytes(Bytes.toBytes((String)"NORMALIZER_TARGET_REGION_SIZE"));
    private static final Durability DEFAULT_DURABLITY = Durability.USE_DEFAULT;
    @InterfaceAudience.Private
    public static final String PRIORITY = "PRIORITY";
    private static final Bytes PRIORITY_KEY = new Bytes(Bytes.toBytes((String)"PRIORITY"));
    private static final int DEFAULT_PRIORITY = 0;
    public static final boolean DEFAULT_READONLY = false;
    public static final boolean DEFAULT_COMPACTION_ENABLED = true;
    public static final boolean DEFAULT_SPLIT_ENABLED = true;
    public static final boolean DEFAULT_MERGE_ENABLED = true;
    public static final boolean DEFAULT_NORMALIZATION_ENABLED = false;
    public static final long DEFAULT_MEMSTORE_FLUSH_SIZE = 0x8000000L;
    public static final int DEFAULT_REGION_REPLICATION = 1;
    public static final boolean DEFAULT_REGION_MEMSTORE_REPLICATION = true;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<Bytes> RESERVED_KEYWORDS = new HashSet<Bytes>();
    @InterfaceAudience.Private
    public static final String NAMESPACE_FAMILY_INFO = "info";
    @InterfaceAudience.Private
    public static final byte[] NAMESPACE_FAMILY_INFO_BYTES;
    @InterfaceAudience.Private
    public static final byte[] NAMESPACE_COL_DESC_BYTES;
    private static final Pattern CP_HTD_ATTR_VALUE_PATTERN;
    private static final String CP_HTD_ATTR_VALUE_PARAM_KEY_PATTERN = "[^=,]+";
    private static final String CP_HTD_ATTR_VALUE_PARAM_VALUE_PATTERN = "[^,]+";
    private static final Pattern CP_HTD_ATTR_VALUE_PARAM_PATTERN;
    private static final Pattern CP_HTD_ATTR_KEY_PATTERN;
    public static final TableDescriptor NAMESPACE_TABLEDESC;
    private final ModifyableTableDescriptor desc;

    public static byte[] toByteArray(TableDescriptor desc) {
        if (desc instanceof ModifyableTableDescriptor) {
            return ((ModifyableTableDescriptor)desc).toByteArray();
        }
        return new ModifyableTableDescriptor(desc).toByteArray();
    }

    public static TableDescriptor parseFrom(byte[] pbBytes) throws DeserializationException {
        return ModifyableTableDescriptor.parseFrom(pbBytes);
    }

    public static TableDescriptorBuilder newBuilder(TableName name) {
        return new TableDescriptorBuilder(name);
    }

    public static TableDescriptor copy(TableDescriptor desc) {
        return new ModifyableTableDescriptor(desc);
    }

    public static TableDescriptor copy(TableName name, TableDescriptor desc) {
        return new ModifyableTableDescriptor(name, desc);
    }

    public static TableDescriptorBuilder newBuilder(TableDescriptor desc) {
        return new TableDescriptorBuilder(desc);
    }

    private TableDescriptorBuilder(TableName name) {
        this.desc = new ModifyableTableDescriptor(name);
    }

    private TableDescriptorBuilder(TableDescriptor desc) {
        this.desc = new ModifyableTableDescriptor(desc);
    }

    @Deprecated
    public TableDescriptorBuilder addCoprocessor(String className) throws IOException {
        return this.addCoprocessor(className, null, 0x3FFFFFFF, null);
    }

    @Deprecated
    public TableDescriptorBuilder addCoprocessor(String className, Path jarFilePath, int priority, Map<String, String> kvs) throws IOException {
        this.desc.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder(className).setJarPath(jarFilePath == null ? null : jarFilePath.toString()).setPriority(priority).setProperties(kvs == null ? Collections.emptyMap() : kvs).build());
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder addCoprocessorWithSpec(String specStr) throws IOException {
        this.desc.setCoprocessorWithSpec(specStr);
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder addColumnFamily(ColumnFamilyDescriptor family) {
        this.desc.setColumnFamily(family);
        return this;
    }

    public TableDescriptorBuilder setCoprocessor(String className) throws IOException {
        return this.setCoprocessor(CoprocessorDescriptorBuilder.of(className));
    }

    public TableDescriptorBuilder setCoprocessor(CoprocessorDescriptor cpDesc) throws IOException {
        this.desc.setCoprocessor(Objects.requireNonNull(cpDesc));
        return this;
    }

    public TableDescriptorBuilder setCoprocessors(Collection<CoprocessorDescriptor> cpDescs) throws IOException {
        for (CoprocessorDescriptor cpDesc : cpDescs) {
            this.desc.setCoprocessor(cpDesc);
        }
        return this;
    }

    public TableDescriptorBuilder setColumnFamily(ColumnFamilyDescriptor family) {
        this.desc.setColumnFamily(Objects.requireNonNull(family));
        return this;
    }

    public TableDescriptorBuilder setColumnFamilies(Collection<ColumnFamilyDescriptor> families) {
        families.forEach(this.desc::setColumnFamily);
        return this;
    }

    public TableDescriptorBuilder modifyColumnFamily(ColumnFamilyDescriptor family) {
        this.desc.modifyColumnFamily(Objects.requireNonNull(family));
        return this;
    }

    public TableDescriptorBuilder removeValue(Bytes key) {
        this.desc.removeValue(key);
        return this;
    }

    public TableDescriptorBuilder removeValue(byte[] key) {
        this.desc.removeValue(key);
        return this;
    }

    public TableDescriptorBuilder removeColumnFamily(byte[] name) {
        this.desc.removeColumnFamily(name);
        return this;
    }

    public TableDescriptorBuilder removeCoprocessor(String className) {
        this.desc.removeCoprocessor(className);
        return this;
    }

    public TableDescriptorBuilder setCompactionEnabled(boolean isEnable) {
        this.desc.setCompactionEnabled(isEnable);
        return this;
    }

    public TableDescriptorBuilder setSplitEnabled(boolean isEnable) {
        this.desc.setSplitEnabled(isEnable);
        return this;
    }

    public TableDescriptorBuilder setMergeEnabled(boolean isEnable) {
        this.desc.setMergeEnabled(isEnable);
        return this;
    }

    public TableDescriptorBuilder setDurability(Durability durability) {
        this.desc.setDurability(durability);
        return this;
    }

    public TableDescriptorBuilder setFlushPolicyClassName(String clazz) {
        this.desc.setFlushPolicyClassName(clazz);
        return this;
    }

    public TableDescriptorBuilder setMaxFileSize(long maxFileSize) {
        this.desc.setMaxFileSize(maxFileSize);
        return this;
    }

    public TableDescriptorBuilder setMemStoreFlushSize(long memstoreFlushSize) {
        this.desc.setMemStoreFlushSize(memstoreFlushSize);
        return this;
    }

    public TableDescriptorBuilder setNormalizerTargetRegionCount(int regionCount) {
        this.desc.setNormalizerTargetRegionCount(regionCount);
        return this;
    }

    public TableDescriptorBuilder setNormalizerTargetRegionSize(long regionSize) {
        this.desc.setNormalizerTargetRegionSize(regionSize);
        return this;
    }

    public TableDescriptorBuilder setNormalizationEnabled(boolean isEnable) {
        this.desc.setNormalizationEnabled(isEnable);
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder setOwner(User owner) {
        this.desc.setOwner(owner);
        return this;
    }

    @Deprecated
    public TableDescriptorBuilder setOwnerString(String ownerString) {
        this.desc.setOwnerString(ownerString);
        return this;
    }

    public TableDescriptorBuilder setPriority(int priority) {
        this.desc.setPriority(priority);
        return this;
    }

    public TableDescriptorBuilder setReadOnly(boolean readOnly) {
        this.desc.setReadOnly(readOnly);
        return this;
    }

    public TableDescriptorBuilder setRegionMemStoreReplication(boolean memstoreReplication) {
        this.desc.setRegionMemStoreReplication(memstoreReplication);
        return this;
    }

    public TableDescriptorBuilder setRegionReplication(int regionReplication) {
        this.desc.setRegionReplication(regionReplication);
        return this;
    }

    public TableDescriptorBuilder setRegionSplitPolicyClassName(String clazz) {
        this.desc.setRegionSplitPolicyClassName(clazz);
        return this;
    }

    public TableDescriptorBuilder setValue(String key, String value) {
        this.desc.setValue(key, value);
        return this;
    }

    public TableDescriptorBuilder setValue(Bytes key, Bytes value) {
        this.desc.setValue(key, value);
        return this;
    }

    public TableDescriptorBuilder setValue(byte[] key, byte[] value) {
        this.desc.setValue(key, value);
        return this;
    }

    public TableDescriptorBuilder setReplicationScope(int scope) {
        TreeMap<byte[], ColumnFamilyDescriptor> newFamilies = new TreeMap<byte[], ColumnFamilyDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        newFamilies.putAll(this.desc.families);
        newFamilies.forEach((cf, cfDesc) -> {
            this.desc.removeColumnFamily((byte[])cf);
            this.desc.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(cfDesc).setScope(scope).build());
        });
        return this;
    }

    public TableDescriptor build() {
        return new ModifyableTableDescriptor(this.desc);
    }

    private static Optional<CoprocessorDescriptor> toCoprocessorDescriptor(String spec) {
        Matcher matcher = CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
        if (matcher.matches()) {
            String path = matcher.group(1).trim().isEmpty() ? null : matcher.group(1).trim();
            String className = matcher.group(2).trim();
            if (className.isEmpty()) {
                return Optional.empty();
            }
            String priorityStr = matcher.group(3).trim();
            int priority = priorityStr.isEmpty() ? 0x3FFFFFFF : Integer.parseInt(priorityStr);
            String cfgSpec = null;
            try {
                cfgSpec = matcher.group(4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            TreeMap<String, String> ourConf = new TreeMap<String, String>();
            if (cfgSpec != null && !cfgSpec.trim().equals("|")) {
                cfgSpec = cfgSpec.substring(cfgSpec.indexOf(124) + 1);
                Matcher m = CP_HTD_ATTR_VALUE_PARAM_PATTERN.matcher(cfgSpec);
                while (m.find()) {
                    ourConf.put(m.group(1), m.group(2));
                }
            }
            return Optional.of(CoprocessorDescriptorBuilder.newBuilder(className).setJarPath(path).setPriority(priority).setProperties(ourConf).build());
        }
        return Optional.empty();
    }

    static {
        DEFAULT_VALUES.put(MAX_FILESIZE, String.valueOf(0x280000000L));
        DEFAULT_VALUES.put(READONLY, String.valueOf(false));
        DEFAULT_VALUES.put(MEMSTORE_FLUSHSIZE, String.valueOf(0x8000000L));
        DEFAULT_VALUES.put(DURABILITY, DEFAULT_DURABLITY.name());
        DEFAULT_VALUES.put(REGION_REPLICATION, String.valueOf(1));
        DEFAULT_VALUES.put(NORMALIZATION_ENABLED, String.valueOf(false));
        DEFAULT_VALUES.put(PRIORITY, String.valueOf(0));
        DEFAULT_VALUES.keySet().stream().map(s -> new Bytes(Bytes.toBytes((String)s))).forEach(RESERVED_KEYWORDS::add);
        RESERVED_KEYWORDS.add(IS_META_KEY);
        NAMESPACE_FAMILY_INFO_BYTES = Bytes.toBytes((String)NAMESPACE_FAMILY_INFO);
        NAMESPACE_COL_DESC_BYTES = Bytes.toBytes((String)"d");
        CP_HTD_ATTR_VALUE_PATTERN = Pattern.compile("(^[^\\|]*)\\|([^\\|]+)\\|[\\s]*([\\d]*)[\\s]*(\\|.*)?$");
        CP_HTD_ATTR_VALUE_PARAM_PATTERN = Pattern.compile("([^=,]+)=([^,]+),?");
        CP_HTD_ATTR_KEY_PATTERN = Pattern.compile("^coprocessor\\$([0-9]+)$", 2);
        NAMESPACE_TABLEDESC = TableDescriptorBuilder.newBuilder(TableName.NAMESPACE_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(NAMESPACE_FAMILY_INFO_BYTES).setMaxVersions(10).setInMemory(true).setBlocksize(8192).setScope(0).build()).build();
    }

    @InterfaceAudience.Private
    public static class ModifyableTableDescriptor
    implements TableDescriptor,
    Comparable<ModifyableTableDescriptor> {
        private final TableName name;
        private final Map<Bytes, Bytes> values = new HashMap<Bytes, Bytes>();
        private final Map<byte[], ColumnFamilyDescriptor> families = new TreeMap<byte[], ColumnFamilyDescriptor>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);

        @InterfaceAudience.Private
        public ModifyableTableDescriptor(TableName name) {
            this(name, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        }

        private ModifyableTableDescriptor(TableDescriptor desc) {
            this(desc.getTableName(), Arrays.asList(desc.getColumnFamilies()), desc.getValues());
        }

        @InterfaceAudience.Private
        @Deprecated
        public ModifyableTableDescriptor(TableName name, TableDescriptor desc) {
            this(name, Arrays.asList(desc.getColumnFamilies()), desc.getValues());
        }

        private ModifyableTableDescriptor(TableName name, Collection<ColumnFamilyDescriptor> families, Map<Bytes, Bytes> values) {
            this.name = name;
            families.forEach(c -> this.families.put(c.getName(), ColumnFamilyDescriptorBuilder.copy(c)));
            this.values.putAll(values);
            this.values.put(IS_META_KEY, new Bytes(Bytes.toBytes((String)Boolean.toString(name.equals((Object)TableName.META_TABLE_NAME)))));
        }

        @Override
        public boolean isMetaRegion() {
            return this.getOrDefault(IS_META_KEY, Boolean::valueOf, false);
        }

        @Override
        public boolean isMetaTable() {
            return this.isMetaRegion();
        }

        @Override
        public Bytes getValue(Bytes key) {
            Bytes rval = this.values.get(key);
            return rval == null ? null : new Bytes(rval.copyBytes());
        }

        @Override
        public String getValue(String key) {
            Bytes rval = this.values.get(new Bytes(Bytes.toBytes((String)key)));
            return rval == null ? null : Bytes.toString((byte[])rval.get(), (int)rval.getOffset(), (int)rval.getLength());
        }

        @Override
        public byte[] getValue(byte[] key) {
            Bytes value = this.values.get(new Bytes(key));
            return value == null ? null : value.copyBytes();
        }

        private <T> T getOrDefault(Bytes key, Function<String, T> function, T defaultValue) {
            Bytes value = this.values.get(key);
            if (value == null) {
                return defaultValue;
            }
            return function.apply(Bytes.toString((byte[])value.get(), (int)value.getOffset(), (int)value.getLength()));
        }

        @Override
        public Map<Bytes, Bytes> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public ModifyableTableDescriptor setValue(byte[] key, byte[] value) {
            return this.setValue(ModifyableTableDescriptor.toBytesOrNull(key, v -> v), ModifyableTableDescriptor.toBytesOrNull(value, v -> v));
        }

        public ModifyableTableDescriptor setValue(String key, String value) {
            return this.setValue(ModifyableTableDescriptor.toBytesOrNull(key, Bytes::toBytes), ModifyableTableDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        private ModifyableTableDescriptor setValue(Bytes key, String value) {
            return this.setValue(key, ModifyableTableDescriptor.toBytesOrNull(value, Bytes::toBytes));
        }

        public ModifyableTableDescriptor setValue(Bytes key, Bytes value) {
            if (value == null) {
                this.values.remove(key);
            } else {
                this.values.put(key, value);
            }
            return this;
        }

        private static <T> Bytes toBytesOrNull(T t, Function<T, byte[]> f) {
            if (t == null) {
                return null;
            }
            return new Bytes(f.apply(t));
        }

        public ModifyableTableDescriptor removeValue(Bytes key) {
            return this.setValue(key, (Bytes)null);
        }

        public ModifyableTableDescriptor removeValue(byte[] key) {
            return this.removeValue(new Bytes(key));
        }

        @Override
        public boolean isReadOnly() {
            return this.getOrDefault(READONLY_KEY, Boolean::valueOf, false);
        }

        public ModifyableTableDescriptor setReadOnly(boolean readOnly) {
            return this.setValue(READONLY_KEY, Boolean.toString(readOnly));
        }

        @Override
        public boolean isCompactionEnabled() {
            return this.getOrDefault(COMPACTION_ENABLED_KEY, Boolean::valueOf, true);
        }

        public ModifyableTableDescriptor setCompactionEnabled(boolean isEnable) {
            return this.setValue(COMPACTION_ENABLED_KEY, Boolean.toString(isEnable));
        }

        @Override
        public boolean isSplitEnabled() {
            return this.getOrDefault(SPLIT_ENABLED_KEY, Boolean::valueOf, true);
        }

        public ModifyableTableDescriptor setSplitEnabled(boolean isEnable) {
            return this.setValue(SPLIT_ENABLED_KEY, Boolean.toString(isEnable));
        }

        @Override
        public boolean isMergeEnabled() {
            return this.getOrDefault(MERGE_ENABLED_KEY, Boolean::valueOf, true);
        }

        public ModifyableTableDescriptor setMergeEnabled(boolean isEnable) {
            return this.setValue(MERGE_ENABLED_KEY, Boolean.toString(isEnable));
        }

        @Override
        public boolean isNormalizationEnabled() {
            return this.getOrDefault(NORMALIZATION_ENABLED_KEY, Boolean::valueOf, false);
        }

        @Override
        public int getNormalizerTargetRegionCount() {
            return this.getOrDefault(NORMALIZER_TARGET_REGION_COUNT_KEY, Integer::valueOf, -1);
        }

        @Override
        public long getNormalizerTargetRegionSize() {
            return this.getOrDefault(NORMALIZER_TARGET_REGION_SIZE_KEY, Long::valueOf, -1L);
        }

        public ModifyableTableDescriptor setNormalizationEnabled(boolean isEnable) {
            return this.setValue(NORMALIZATION_ENABLED_KEY, Boolean.toString(isEnable));
        }

        public ModifyableTableDescriptor setNormalizerTargetRegionCount(int regionCount) {
            return this.setValue(NORMALIZER_TARGET_REGION_COUNT_KEY, Integer.toString(regionCount));
        }

        public ModifyableTableDescriptor setNormalizerTargetRegionSize(long regionSize) {
            return this.setValue(NORMALIZER_TARGET_REGION_SIZE_KEY, Long.toString(regionSize));
        }

        public ModifyableTableDescriptor setDurability(Durability durability) {
            return this.setValue(DURABILITY_KEY, durability.name());
        }

        @Override
        public Durability getDurability() {
            return this.getOrDefault(DURABILITY_KEY, Durability::valueOf, DEFAULT_DURABLITY);
        }

        @Override
        public TableName getTableName() {
            return this.name;
        }

        public ModifyableTableDescriptor setRegionSplitPolicyClassName(String clazz) {
            return this.setValue(SPLIT_POLICY_KEY, clazz);
        }

        @Override
        public String getRegionSplitPolicyClassName() {
            return this.getOrDefault(SPLIT_POLICY_KEY, Function.identity(), null);
        }

        @Override
        public long getMaxFileSize() {
            return this.getOrDefault(MAX_FILESIZE_KEY, Long::valueOf, -1L);
        }

        public ModifyableTableDescriptor setMaxFileSize(long maxFileSize) {
            return this.setValue(MAX_FILESIZE_KEY, Long.toString(maxFileSize));
        }

        @Override
        public long getMemStoreFlushSize() {
            return this.getOrDefault(MEMSTORE_FLUSHSIZE_KEY, Long::valueOf, -1L);
        }

        public ModifyableTableDescriptor setMemStoreFlushSize(long memstoreFlushSize) {
            return this.setValue(MEMSTORE_FLUSHSIZE_KEY, Long.toString(memstoreFlushSize));
        }

        public ModifyableTableDescriptor setFlushPolicyClassName(String clazz) {
            return this.setValue(FLUSH_POLICY_KEY, clazz);
        }

        @Override
        public String getFlushPolicyClassName() {
            return this.getOrDefault(FLUSH_POLICY_KEY, Function.identity(), null);
        }

        public ModifyableTableDescriptor setColumnFamily(ColumnFamilyDescriptor family) {
            if (family.getName() == null || family.getName().length <= 0) {
                throw new IllegalArgumentException("Family name cannot be null or empty");
            }
            if (this.hasColumnFamily(family.getName())) {
                throw new IllegalArgumentException("Family '" + family.getNameAsString() + "' already exists so cannot be added");
            }
            return this.putColumnFamily(family);
        }

        public ModifyableTableDescriptor modifyColumnFamily(ColumnFamilyDescriptor family) {
            if (family.getName() == null || family.getName().length <= 0) {
                throw new IllegalArgumentException("Family name cannot be null or empty");
            }
            if (!this.hasColumnFamily(family.getName())) {
                throw new IllegalArgumentException("Column family '" + family.getNameAsString() + "' does not exist");
            }
            return this.putColumnFamily(family);
        }

        private ModifyableTableDescriptor putColumnFamily(ColumnFamilyDescriptor family) {
            this.families.put(family.getName(), family);
            return this;
        }

        @Override
        public boolean hasColumnFamily(byte[] familyName) {
            return this.families.containsKey(familyName);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
            s.append((CharSequence)this.getValues(true));
            this.families.values().forEach(f -> s.append(", ").append(f));
            return s.toString();
        }

        @Override
        public String toStringCustomizedValues() {
            StringBuilder s = new StringBuilder();
            s.append('\'').append(Bytes.toString((byte[])this.name.getName())).append('\'');
            s.append((CharSequence)this.getValues(false));
            this.families.values().forEach(hcd -> s.append(", ").append(hcd.toStringCustomizedValues()));
            return s.toString();
        }

        public String toStringTableAttributes() {
            return this.getValues(true).toString();
        }

        private StringBuilder getValues(boolean printDefaults) {
            boolean hasAttributes;
            StringBuilder s = new StringBuilder();
            TreeSet<Bytes> reservedKeys = new TreeSet<Bytes>();
            TreeSet<Bytes> userKeys = new TreeSet<Bytes>();
            for (Map.Entry<Bytes, Bytes> entry : this.values.entrySet()) {
                if (entry.getKey() == null || entry.getKey().get() == null) continue;
                String key = Bytes.toString((byte[])entry.getKey().get());
                if (!RESERVED_KEYWORDS.contains(entry.getKey()) && !key.startsWith("coprocessor$")) {
                    userKeys.add(entry.getKey());
                    continue;
                }
                String value = Bytes.toString((byte[])entry.getValue().get());
                if (key.equalsIgnoreCase(TableDescriptorBuilder.IS_META) && !Boolean.valueOf(value).booleanValue() || !printDefaults && DEFAULT_VALUES.containsKey(key) && ((String)DEFAULT_VALUES.get(key)).equalsIgnoreCase(value)) continue;
                reservedKeys.add(entry.getKey());
            }
            boolean bl = hasAttributes = !reservedKeys.isEmpty() || !userKeys.isEmpty();
            if (!hasAttributes) {
                return s;
            }
            s.append(", {");
            if (hasAttributes) {
                s.append("TABLE_ATTRIBUTES => {");
                boolean printCommaForAttr = false;
                for (Bytes k : reservedKeys) {
                    String key = Bytes.toString((byte[])k.get());
                    String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
                    if (printCommaForAttr) {
                        s.append(", ");
                    }
                    printCommaForAttr = true;
                    s.append(key);
                    s.append(" => ");
                    s.append('\'').append(value).append('\'');
                }
                if (!userKeys.isEmpty()) {
                    if (printCommaForAttr) {
                        s.append(", ");
                    }
                    s.append("METADATA").append(" => ");
                    s.append("{");
                    boolean printCommaForCfg = false;
                    for (Bytes k : userKeys) {
                        String key = Bytes.toString((byte[])k.get());
                        String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
                        if (printCommaForCfg) {
                            s.append(", ");
                        }
                        printCommaForCfg = true;
                        s.append('\'').append(key).append('\'');
                        s.append(" => ");
                        s.append('\'').append(value).append('\'');
                    }
                    s.append("}");
                }
                s.append("}");
            }
            s.append("}");
            return s;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModifyableTableDescriptor) {
                return TableDescriptor.COMPARATOR.compare(this, (ModifyableTableDescriptor)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            if (this.families.size() > 0) {
                for (ColumnFamilyDescriptor e : this.families.values()) {
                    result ^= e.hashCode();
                }
            }
            return result ^= this.values.hashCode();
        }

        @Override
        public int compareTo(ModifyableTableDescriptor other) {
            return TableDescriptor.COMPARATOR.compare(this, other);
        }

        @Override
        public ColumnFamilyDescriptor[] getColumnFamilies() {
            return this.families.values().toArray(new ColumnFamilyDescriptor[this.families.size()]);
        }

        @Override
        public int getRegionReplication() {
            return this.getOrDefault(REGION_REPLICATION_KEY, Integer::valueOf, 1);
        }

        public ModifyableTableDescriptor setRegionReplication(int regionReplication) {
            return this.setValue(REGION_REPLICATION_KEY, Integer.toString(regionReplication));
        }

        @Override
        public boolean hasRegionMemStoreReplication() {
            return this.getOrDefault(REGION_MEMSTORE_REPLICATION_KEY, Boolean::valueOf, true);
        }

        public ModifyableTableDescriptor setRegionMemStoreReplication(boolean memstoreReplication) {
            this.setValue(REGION_MEMSTORE_REPLICATION_KEY, Boolean.toString(memstoreReplication));
            return this.setValue(REGION_REPLICA_WAIT_FOR_PRIMARY_FLUSH_CONF_KEY, Boolean.toString(memstoreReplication));
        }

        public ModifyableTableDescriptor setPriority(int priority) {
            return this.setValue(PRIORITY_KEY, Integer.toString(priority));
        }

        @Override
        public int getPriority() {
            return this.getOrDefault(PRIORITY_KEY, Integer::valueOf, 0);
        }

        @Override
        public Set<byte[]> getColumnFamilyNames() {
            return Collections.unmodifiableSet(this.families.keySet());
        }

        @Override
        public ColumnFamilyDescriptor getColumnFamily(byte[] column) {
            return this.families.get(column);
        }

        public ColumnFamilyDescriptor removeColumnFamily(byte[] column) {
            return this.families.remove(column);
        }

        public ModifyableTableDescriptor setCoprocessor(String className) throws IOException {
            return this.setCoprocessor(CoprocessorDescriptorBuilder.newBuilder(className).setPriority(0x3FFFFFFF).build());
        }

        public ModifyableTableDescriptor setCoprocessor(CoprocessorDescriptor cp) throws IOException {
            this.checkHasCoprocessor(cp.getClassName());
            if (cp.getPriority() < 0) {
                throw new IOException("Priority must be bigger than or equal with zero, current:" + cp.getPriority());
            }
            StringBuilder kvString = new StringBuilder();
            for (Map.Entry<String, String> e : cp.getProperties().entrySet()) {
                if (!e.getKey().matches(TableDescriptorBuilder.CP_HTD_ATTR_VALUE_PARAM_KEY_PATTERN)) {
                    throw new IOException("Illegal parameter key = " + e.getKey());
                }
                if (!e.getValue().matches(TableDescriptorBuilder.CP_HTD_ATTR_VALUE_PARAM_VALUE_PATTERN)) {
                    throw new IOException("Illegal parameter (" + e.getKey() + ") value = " + e.getValue());
                }
                if (kvString.length() != 0) {
                    kvString.append(',');
                }
                kvString.append(e.getKey());
                kvString.append('=');
                kvString.append(e.getValue());
            }
            String value = cp.getJarPath().orElse("") + "|" + cp.getClassName() + "|" + Integer.toString(cp.getPriority()) + "|" + kvString.toString();
            return this.setCoprocessorToMap(value);
        }

        @Deprecated
        public ModifyableTableDescriptor setCoprocessorWithSpec(String specStr) throws IOException {
            CoprocessorDescriptor cpDesc = (CoprocessorDescriptor)TableDescriptorBuilder.toCoprocessorDescriptor(specStr).orElseThrow(() -> new IllegalArgumentException("Format does not match " + CP_HTD_ATTR_VALUE_PATTERN + ": " + specStr));
            this.checkHasCoprocessor(cpDesc.getClassName());
            return this.setCoprocessorToMap(specStr);
        }

        private void checkHasCoprocessor(String className) throws IOException {
            if (this.hasCoprocessor(className)) {
                throw new IOException("Coprocessor " + className + " already exists.");
            }
        }

        private ModifyableTableDescriptor setCoprocessorToMap(String specStr) {
            if (specStr == null) {
                return this;
            }
            int maxCoprocessorNumber = 0;
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                Matcher keyMatcher = CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches()) continue;
                maxCoprocessorNumber = Math.max(Integer.parseInt(keyMatcher.group(1)), maxCoprocessorNumber);
            }
            String key = "coprocessor$" + Integer.toString(++maxCoprocessorNumber);
            return this.setValue(new Bytes(Bytes.toBytes((String)key)), new Bytes(Bytes.toBytes((String)specStr)));
        }

        @Override
        public boolean hasCoprocessor(String classNameToMatch) {
            return this.getCoprocessorDescriptors().stream().anyMatch(cp -> cp.getClassName().equals(classNameToMatch));
        }

        public List<CoprocessorDescriptor> getCoprocessorDescriptors() {
            ArrayList<CoprocessorDescriptor> result = new ArrayList<CoprocessorDescriptor>();
            for (Map.Entry<Bytes, Bytes> e : this.getValues().entrySet()) {
                String key = Bytes.toString((byte[])e.getKey().get()).trim();
                if (!CP_HTD_ATTR_KEY_PATTERN.matcher(key).matches()) continue;
                TableDescriptorBuilder.toCoprocessorDescriptor(Bytes.toString((byte[])e.getValue().get()).trim()).ifPresent(result::add);
            }
            return result;
        }

        public void removeCoprocessor(String className) {
            Bytes match = null;
            for (Map.Entry<Bytes, Bytes> e : this.values.entrySet()) {
                String clazz;
                Matcher valueMatcher;
                Matcher keyMatcher = CP_HTD_ATTR_KEY_PATTERN.matcher(Bytes.toString((byte[])e.getKey().get()));
                if (!keyMatcher.matches() || !(valueMatcher = CP_HTD_ATTR_VALUE_PATTERN.matcher(Bytes.toString((byte[])e.getValue().get()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
                match = e.getKey();
                break;
            }
            if (match != null) {
                this.removeValue(match);
            }
        }

        @Deprecated
        public ModifyableTableDescriptor setOwner(User owner) {
            return this.setOwnerString(owner != null ? owner.getShortName() : null);
        }

        @Deprecated
        public ModifyableTableDescriptor setOwnerString(String ownerString) {
            return this.setValue(OWNER_KEY, ownerString);
        }

        @Override
        @Deprecated
        public String getOwnerString() {
            return this.getOrDefault(OWNER_KEY, Function.identity(), null);
        }

        private byte[] toByteArray() {
            return ProtobufUtil.prependPBMagic(ProtobufUtil.toTableSchema(this).toByteArray());
        }

        private static TableDescriptor parseFrom(byte[] bytes) throws DeserializationException {
            if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
                throw new DeserializationException("Expected PB encoded ModifyableTableDescriptor");
            }
            int pblen = ProtobufUtil.lengthOfPBMagic();
            HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                return ProtobufUtil.toTableDescriptor(builder.build());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }

        @Override
        public int getColumnFamilyCount() {
            return this.families.size();
        }
    }
}

