/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSelector;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CatalogReplicaLoadBalanceSimpleSelector
implements CatalogReplicaLoadBalanceSelector,
Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogReplicaLoadBalanceSimpleSelector.class);
    private final long STALE_CACHE_TIMEOUT_IN_MILLISECONDS = 3000L;
    private final int STALE_CACHE_CLEAN_CHORE_INTERVAL_IN_MILLISECONDS = 1500;
    private final int REFRESH_REPLICA_COUNT_CHORE_INTERVAL_IN_MILLISECONDS = 60000;
    private final ConcurrentMap<TableName, ConcurrentNavigableMap<byte[], StaleLocationCacheEntry>> staleCache = new ConcurrentHashMap<TableName, ConcurrentNavigableMap<byte[], StaleLocationCacheEntry>>();
    private volatile int numOfReplicas;
    private final ChoreService choreService;
    private final TableName tableName;
    private final IntSupplier getNumOfReplicas;
    private volatile boolean isStopped = false;

    CatalogReplicaLoadBalanceSimpleSelector(TableName tableName, ChoreService choreService, IntSupplier getNumOfReplicas) {
        this.choreService = choreService;
        this.tableName = tableName;
        this.getNumOfReplicas = getNumOfReplicas;
        this.numOfReplicas = -1;
        this.choreService.scheduleChore(this.getCacheCleanupChore(this));
        this.choreService.scheduleChore(this.getRefreshReplicaCountChore(this));
    }

    @Override
    public void onError(HRegionLocation loc) {
        ConcurrentNavigableMap tableCache = (ConcurrentNavigableMap)ConcurrentMapUtils.computeIfAbsent(this.staleCache, (Object)loc.getRegion().getTable(), () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
        byte[] startKey = loc.getRegion().getStartKey();
        tableCache.putIfAbsent(startKey, new StaleLocationCacheEntry(loc.getRegion().getEndKey()));
        LOG.debug("Add entry to stale cache for table {} with startKey {}, {}", new Object[]{loc.getRegion().getTable(), startKey, loc.getRegion().getEndKey()});
    }

    private int getRandomReplicaId() {
        int cachedNumOfReplicas = this.numOfReplicas;
        if (cachedNumOfReplicas == -1) {
            this.numOfReplicas = cachedNumOfReplicas = this.refreshCatalogReplicaCount();
        }
        if (cachedNumOfReplicas <= 1) {
            return 0;
        }
        return 1 + ThreadLocalRandom.current().nextInt(cachedNumOfReplicas - 1);
    }

    @Override
    public int select(TableName tablename, byte[] row, RegionLocateType locateType) {
        Preconditions.checkArgument((locateType == RegionLocateType.BEFORE || locateType == RegionLocateType.CURRENT ? 1 : 0) != 0, (String)"Expected type BEFORE or CURRENT but got: %s", (Object)((Object)locateType));
        ConcurrentNavigableMap tableCache = (ConcurrentNavigableMap)this.staleCache.get(tablename);
        if (tableCache == null) {
            return this.getRandomReplicaId();
        }
        boolean isEmptyStopRow = ConnectionUtils.isEmptyStopRow(row);
        Map.Entry entry = locateType == RegionLocateType.BEFORE ? (isEmptyStopRow ? tableCache.lastEntry() : tableCache.lowerEntry(row)) : tableCache.floorEntry(row);
        if (entry == null) {
            return this.getRandomReplicaId();
        }
        if (EnvironmentEdgeManager.currentTime() - ((StaleLocationCacheEntry)entry.getValue()).getTimestamp() >= 3000L) {
            LOG.debug("Entry for table {} with startKey {}, {} times out", new Object[]{tablename, entry.getKey(), entry});
            tableCache.remove(entry.getKey());
            return this.getRandomReplicaId();
        }
        byte[] endKey = ((StaleLocationCacheEntry)entry.getValue()).getEndKey();
        if (ConnectionUtils.isEmptyStopRow(endKey)) {
            LOG.debug("Lookup {} goes to primary region", (Object)row);
            return 0;
        }
        if (locateType == RegionLocateType.BEFORE) {
            if (!isEmptyStopRow && Bytes.compareTo((byte[])endKey, (byte[])row) >= 0) {
                LOG.debug("Lookup {} goes to primary meta", (Object)row);
                return 0;
            }
        } else if (Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
            LOG.debug("Lookup {} goes to primary meta", (Object)row);
            return 0;
        }
        return this.getRandomReplicaId();
    }

    public void stop(String why) {
        this.isStopped = true;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    private void cleanupReplicaReplicaStaleCache() {
        long curTimeInMills = EnvironmentEdgeManager.currentTime();
        for (ConcurrentNavigableMap tableCache : this.staleCache.values()) {
            Iterator it = tableCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (curTimeInMills - ((StaleLocationCacheEntry)entry.getValue()).getTimestamp() < 3000L) continue;
                LOG.debug("clean entry {}, {} from stale cache", entry.getKey(), entry.getValue());
                it.remove();
            }
        }
    }

    private int refreshCatalogReplicaCount() {
        int newNumOfReplicas = this.getNumOfReplicas.getAsInt();
        LOG.debug("Refreshed replica count {}", (Object)newNumOfReplicas);
        if (newNumOfReplicas == -1) {
            LOG.error("Failed to fetch Table {}'s region replica count", (Object)this.tableName);
            return this.numOfReplicas;
        }
        int cachedNumOfReplicas = this.numOfReplicas;
        if (cachedNumOfReplicas == -1 || cachedNumOfReplicas != newNumOfReplicas) {
            this.numOfReplicas = newNumOfReplicas;
        }
        return newNumOfReplicas;
    }

    private ScheduledChore getCacheCleanupChore(final CatalogReplicaLoadBalanceSimpleSelector selector) {
        return new ScheduledChore("CleanupCatalogReplicaStaleCache", this, 1500){

            protected void chore() {
                selector.cleanupReplicaReplicaStaleCache();
            }
        };
    }

    private ScheduledChore getRefreshReplicaCountChore(final CatalogReplicaLoadBalanceSimpleSelector selector) {
        return new ScheduledChore("RefreshReplicaCountChore", this, 60000){

            protected void chore() {
                selector.refreshCatalogReplicaCount();
            }
        };
    }

    private static final class StaleLocationCacheEntry {
        private final long timestamp;
        private final byte[] endKey;

        StaleLocationCacheEntry(byte[] endKey) {
            this.endKey = endKey;
            this.timestamp = EnvironmentEdgeManager.currentTime();
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("endKey", this.endKey).append("timestamp", this.timestamp).toString();
        }
    }
}

