/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;

@InterfaceAudience.Private
public class KeyValueCodecWithTags
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new KeyValueDecoder(is);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new KeyValueEncoder(os);
    }

    public static class KeyValueDecoder
    extends BaseDecoder {
        public KeyValueDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            return KeyValue.iscreate(this.in);
        }
    }

    public static class KeyValueEncoder
    extends BaseEncoder {
        public KeyValueEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            KeyValue.oswrite(KeyValueUtil.ensureKeyValue(cell), this.out, true);
        }
    }
}

