/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IterableUtils;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class KeyValueUtil {
    public static int length(Cell cell) {
        return (int)KeyValue.getKeyValueDataStructureSize(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength(), cell.getValueLength(), cell.getTagsLengthUnsigned());
    }

    public static int keyLength(Cell cell) {
        return (int)KeyValue.getKeyDataStructureSize(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength());
    }

    public static int lengthWithMvccVersion(KeyValue kv, boolean includeMvccVersion) {
        int length = kv.getLength();
        if (includeMvccVersion) {
            length += WritableUtils.getVIntSize((long)kv.getMvccVersion());
        }
        return length;
    }

    public static int totalLengthWithMvccVersion(Iterable<? extends KeyValue> kvs, boolean includeMvccVersion) {
        int length = 0;
        for (KeyValue keyValue : IterableUtils.nullSafe(kvs)) {
            length += KeyValueUtil.lengthWithMvccVersion(keyValue, includeMvccVersion);
        }
        return length;
    }

    public static KeyValue copyToNewKeyValue(Cell cell) {
        byte[] bytes = KeyValueUtil.copyToNewByteArray(cell);
        KeyValue kvCell = new KeyValue(bytes, 0, bytes.length);
        kvCell.setMvccVersion(cell.getMvccVersion());
        return kvCell;
    }

    public static ByteBuffer copyKeyToNewByteBuffer(Cell cell) {
        byte[] bytes = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyToByteArrayWithoutValue(cell, bytes, 0);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.position(buffer.limit());
        return buffer;
    }

    public static byte[] copyToNewByteArray(Cell cell) {
        int v1Length = KeyValueUtil.length(cell);
        byte[] backingBytes = new byte[v1Length];
        KeyValueUtil.appendToByteArray(cell, backingBytes, 0);
        return backingBytes;
    }

    protected static int appendKeyToByteArrayWithoutValue(Cell cell, byte[] output, int offset) {
        int nextOffset = offset;
        nextOffset = Bytes.putShort(output, nextOffset, cell.getRowLength());
        nextOffset = CellUtil.copyRowTo(cell, output, nextOffset);
        nextOffset = Bytes.putByte(output, nextOffset, cell.getFamilyLength());
        nextOffset = CellUtil.copyFamilyTo(cell, output, nextOffset);
        nextOffset = CellUtil.copyQualifierTo(cell, output, nextOffset);
        nextOffset = Bytes.putLong(output, nextOffset, cell.getTimestamp());
        nextOffset = Bytes.putByte(output, nextOffset, cell.getTypeByte());
        return nextOffset;
    }

    public static int appendToByteArray(Cell cell, byte[] output, int offset) {
        int pos = offset;
        pos = Bytes.putInt(output, pos, KeyValueUtil.keyLength(cell));
        pos = Bytes.putInt(output, pos, cell.getValueLength());
        pos = KeyValueUtil.appendKeyToByteArrayWithoutValue(cell, output, pos);
        pos = CellUtil.copyValueTo(cell, output, pos);
        if (cell.getTagsLengthUnsigned() > 0) {
            pos = Bytes.putAsShort(output, pos, cell.getTagsLengthUnsigned());
            pos = CellUtil.copyTagTo(cell, output, pos);
        }
        return pos;
    }

    public static ByteBuffer copyToNewByteBuffer(Cell cell) {
        byte[] bytes = new byte[KeyValueUtil.length(cell)];
        KeyValueUtil.appendToByteArray(cell, bytes, 0);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.position(buffer.limit());
        return buffer;
    }

    public static void appendToByteBuffer(ByteBuffer bb, KeyValue kv, boolean includeMvccVersion) {
        bb.limit(bb.position() + kv.getLength());
        bb.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
        if (includeMvccVersion) {
            int numMvccVersionBytes = WritableUtils.getVIntSize((long)kv.getMvccVersion());
            ByteBufferUtils.extendLimit(bb, numMvccVersionBytes);
            ByteBufferUtils.writeVLong(bb, kv.getMvccVersion());
        }
    }

    public static KeyValue nextShallowCopy(ByteBuffer bb, boolean includesMvccVersion, boolean includesTags) {
        if (bb.isDirect()) {
            throw new IllegalArgumentException("only supports heap buffers");
        }
        if (bb.remaining() < 1) {
            return null;
        }
        KeyValue keyValue = null;
        int underlyingArrayOffset = bb.arrayOffset() + bb.position();
        int keyLength = bb.getInt();
        int valueLength = bb.getInt();
        ByteBufferUtils.skip(bb, keyLength + valueLength);
        int tagsLength = 0;
        if (includesTags) {
            tagsLength = (bb.get() & 0xFF) << 8 ^ bb.get() & 0xFF;
            ByteBufferUtils.skip(bb, tagsLength);
        }
        int kvLength = (int)KeyValue.getKeyValueDataStructureSize(keyLength, valueLength, tagsLength);
        keyValue = new KeyValue(bb.array(), underlyingArrayOffset, kvLength);
        if (includesMvccVersion) {
            long mvccVersion = ByteBufferUtils.readVLong(bb);
            keyValue.setMvccVersion(mvccVersion);
        }
        return keyValue;
    }

    public static KeyValue createFirstKeyInNextRow(Cell in) {
        byte[] nextRow = new byte[in.getRowLength() + 1];
        System.arraycopy(in.getRowArray(), in.getRowOffset(), nextRow, 0, in.getRowLength());
        nextRow[nextRow.length - 1] = 0;
        return KeyValue.createFirstOnRow(nextRow);
    }

    public static KeyValue createFirstKeyInIncrementedRow(Cell in) {
        byte[] thisRow = new SimpleByteRange(in.getRowArray(), in.getRowOffset(), in.getRowLength()).deepCopyToNewArray();
        byte[] nextRow = Bytes.unsignedCopyAndIncrement(thisRow);
        return KeyValue.createFirstOnRow(nextRow);
    }

    public static KeyValue previousKey(KeyValue in) {
        return KeyValue.createFirstOnRow(CellUtil.cloneRow(in), CellUtil.cloneFamily(in), CellUtil.cloneQualifier(in), in.getTimestamp() - 1L);
    }

    public static KeyValue ensureKeyValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        return cell instanceof KeyValue ? (KeyValue)cell : KeyValueUtil.copyToNewKeyValue(cell);
    }

    public static List<KeyValue> ensureKeyValues(List<Cell> cells) {
        List lazyList = Lists.transform(cells, (Function)new Function<Cell, KeyValue>(){

            public KeyValue apply(Cell arg0) {
                return KeyValueUtil.ensureKeyValue(arg0);
            }
        });
        return new ArrayList<KeyValue>(lazyList);
    }
}

