/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestAddress {
    @Test
    public void testGetHostWithoutDomain() {
        Assert.assertEquals((Object)"a:123", (Object)this.toStringWithoutDomain(Address.fromParts((String)"a.b.c", (int)123)));
        Assert.assertEquals((Object)"1:123", (Object)this.toStringWithoutDomain(Address.fromParts((String)"1.b.c", (int)123)));
        Assert.assertEquals((Object)"123.456.789.1:123", (Object)this.toStringWithoutDomain(Address.fromParts((String)"123.456.789.1", (int)123)));
        Assert.assertEquals((Object)"[2001:db8::1]:80", (Object)this.toStringWithoutDomain(Address.fromParts((String)"[2001:db8::1]", (int)80)));
    }

    private String toStringWithoutDomain(Address address) {
        String hostname = address.getHostname();
        String[] parts = hostname.split("\\.");
        if (parts.length > 1) {
            for (String part : parts) {
                if (StringUtils.isNumeric((String)part)) continue;
                return Address.fromParts((String)parts[0], (int)address.getPort()).toString();
            }
        }
        return address.toString();
    }
}

