/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSimplePositionedMutableByteRange {
    @Test
    public void testPosition() {
        SimplePositionedMutableByteRange r = new SimplePositionedMutableByteRange(new byte[5], 1, 3);
        r.put(Bytes.toBytes((String)"f")[0]).put(Bytes.toBytes((String)"o")[0]).put(Bytes.toBytes((String)"o")[0]);
        Assert.assertEquals((long)3L, (long)r.getPosition());
        Assert.assertArrayEquals((byte[])new byte[]{0, Bytes.toBytes((String)"f")[0], Bytes.toBytes((String)"o")[0], Bytes.toBytes((String)"o")[0], 0}, (byte[])r.getBytes());
        r.setPosition(0);
        r.put(Bytes.toBytes((String)"f")).put(Bytes.toBytes((String)"o")).put(Bytes.toBytes((String)"o"));
        Assert.assertEquals((long)3L, (long)r.getPosition());
        Assert.assertArrayEquals((byte[])new byte[]{0, Bytes.toBytes((String)"f")[0], Bytes.toBytes((String)"o")[0], Bytes.toBytes((String)"o")[0], 0}, (byte[])r.getBytes());
        r.setPosition(0);
        Assert.assertEquals((long)Bytes.toBytes((String)"f")[0], (long)r.get());
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        r.setPosition(1);
        Assert.assertEquals((long)Bytes.toBytes((String)"o")[0], (long)r.get());
        r.setPosition(0);
        byte[] dst = new byte[3];
        r.get(dst);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"foo"), (byte[])dst);
        r.setPosition(3);
    }

    @Test
    public void testPutAndGetPrimitiveTypes() throws Exception {
        SimplePositionedMutableByteRange pbr = new SimplePositionedMutableByteRange(100);
        int i1 = 18;
        int i2 = 2;
        short s1 = 0;
        long l1 = 1234L;
        pbr.putInt(i1);
        pbr.putInt(i2);
        pbr.putShort(s1);
        pbr.putLong(l1);
        pbr.putVLong(0L);
        pbr.putVLong(l1);
        pbr.putVLong(Long.MAX_VALUE);
        pbr.putVLong(Long.MIN_VALUE);
        pbr.setPosition(0);
        Assert.assertEquals((long)i1, (long)pbr.getInt());
        Assert.assertEquals((long)i2, (long)pbr.getInt());
        Assert.assertEquals((long)s1, (long)pbr.getShort());
        Assert.assertEquals((long)l1, (long)pbr.getLong());
        Assert.assertEquals((long)0L, (long)pbr.getVLong());
        Assert.assertEquals((long)l1, (long)pbr.getVLong());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)pbr.getVLong());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pbr.getVLong());
    }

    @Test
    public void testPutGetAPIsCompareWithBBAPIs() throws Exception {
        SimplePositionedMutableByteRange pbr = new SimplePositionedMutableByteRange(100);
        int i1 = -234;
        int i2 = 2;
        short s1 = 0;
        long l1 = 1234L;
        pbr.putInt(i1);
        pbr.putShort(s1);
        pbr.putInt(i2);
        pbr.putLong(l1);
        pbr.setPosition(0);
        Assert.assertEquals((long)i1, (long)pbr.getInt());
        Assert.assertEquals((long)s1, (long)pbr.getShort());
        Assert.assertEquals((long)i2, (long)pbr.getInt());
        Assert.assertEquals((long)l1, (long)pbr.getLong());
        ByteBuffer bb = ByteBuffer.wrap(pbr.getBytes());
        Assert.assertEquals((long)i1, (long)bb.getInt());
        Assert.assertEquals((long)s1, (long)bb.getShort());
        Assert.assertEquals((long)i2, (long)bb.getInt());
        Assert.assertEquals((long)l1, (long)bb.getLong());
    }
}

